/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionModel$;
import org.apache.spark.mllib.classification.LogisticRegressionWithLBFGS;
import org.apache.spark.mllib.evaluation.MulticlassMetrics;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class LogisticRegressionWithLBFGSExample$ {
    public static final LogisticRegressionWithLBFGSExample$ MODULE$;

    static {
        new LogisticRegressionWithLBFGSExample$();
    }

    public void main(String[] args) {
        SparkConf conf = new SparkConf().setAppName("LogisticRegressionWithLBFGSExample");
        SparkContext sc = new SparkContext(conf);
        RDD data = MLUtils$.MODULE$.loadLibSVMFile(sc, "data/mllib/sample_libsvm_data.txt");
        RDD[] splits = data.randomSplit(new double[]{0.6, 0.4}, 11L);
        RDD training = splits[0].cache();
        RDD test = splits[1];
        LogisticRegressionModel model = new LogisticRegressionWithLBFGS().setNumClasses(10).run(training);
        RDD predictionAndLabels = test.map((Function1)new Serializable(model){
            public static final long serialVersionUID = 0L;
            private final LogisticRegressionModel model$1;

            public final Tuple2<Object, Object> apply(LabeledPoint x0$1) {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector features = labeledPoint.features();
                    double prediction = this.model$1.predict(features);
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(prediction, label);
                    return sp2;
                }
                throw new MatchError((Object)labeledPoint);
            }
            {
                this.model$1 = model$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        MulticlassMetrics metrics = new MulticlassMetrics(predictionAndLabels);
        double accuracy = metrics.accuracy();
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Accuracy = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)accuracy)})));
        model.save(sc, "target/tmp/scalaLogisticRegressionWithLBFGSModel");
        LogisticRegressionModel sameModel = LogisticRegressionModel$.MODULE$.load(sc, "target/tmp/scalaLogisticRegressionWithLBFGSModel");
        sc.stop();
    }

    private LogisticRegressionWithLBFGSExample$() {
        MODULE$ = this;
    }
}

