/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.mllib;

import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.clustering.BisectingKMeans;
import org.apache.spark.mllib.clustering.BisectingKMeansModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BisectingKMeansExample$ {
    public static final BisectingKMeansExample$ MODULE$;

    static {
        new BisectingKMeansExample$();
    }

    public void main(String[] args) {
        SparkConf sparkConf = new SparkConf().setAppName("mllib.BisectingKMeansExample");
        SparkContext sc = new SparkContext(sparkConf);
        RDD data = sc.textFile("data/mllib/kmeans_data.txt", sc.textFile$default$2()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(String line) {
                return BisectingKMeansExample$.MODULE$.org$apache$spark$examples$mllib$BisectingKMeansExample$$parse$1(line);
            }
        }, ClassTag$.MODULE$.apply(Vector.class)).cache();
        BisectingKMeans bkm = new BisectingKMeans().setK(6);
        BisectingKMeansModel model = bkm.run(data);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compute Cost: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)model.computeCost(data))})));
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])model.clusterCenters()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector center = (Vector)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cluster Center ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)idx), center})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        sc.stop();
    }

    public final Vector org$apache$spark$examples$mllib$BisectingKMeansExample$$parse$1(String line) {
        return Vectors$.MODULE$.dense((double[])Predef$.MODULE$.refArrayOps((Object[])line.split(" ")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toDouble();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
    }

    private BisectingKMeansExample$() {
        MODULE$ = this;
    }
}

