/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.LDA;
import org.apache.spark.ml.clustering.LDAModel;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;

public final class LDAExample$ {
    public static final LDAExample$ MODULE$;

    static {
        new LDAExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName()}))).getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_lda_libsvm_data.txt");
        LDA lda = new LDA().setK(10).setMaxIter(10);
        LDAModel model = lda.fit(dataset);
        double ll = model.logLikelihood(dataset);
        double lp = model.logPerplexity(dataset);
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The lower bound on the log likelihood of the entire corpus: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)ll)})));
        Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The upper bound on perplexity: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)lp)})));
        Dataset topics = model.describeTopics(3);
        Predef$.MODULE$.println((Object)"The topics described by their top-weighted terms:");
        topics.show(false);
        Dataset transformed = model.transform(dataset);
        transformed.show(false);
        spark.stop();
    }

    private LDAExample$() {
        MODULE$ = this;
    }
}

