/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.clustering.BisectingKMeans;
import org.apache.spark.ml.clustering.BisectingKMeansModel;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;

public class JavaBisectingKMeansExample {
    public static void main(String[] args) {
        Vector[] centers;
        SparkSession spark = SparkSession.builder().appName("JavaBisectingKMeansExample").getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_kmeans_data.txt");
        BisectingKMeans bkm = new BisectingKMeans().setK(2).setSeed(1L);
        BisectingKMeansModel model = bkm.fit(dataset);
        double cost = model.computeCost(dataset);
        System.out.println("Within Set Sum of Squared Errors = " + cost);
        System.out.println("Cluster Centers: ");
        for (Vector center : centers = model.clusterCenters()) {
            System.out.println(center);
        }
        spark.stop();
    }
}

