/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler.cluster.k8s;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.dsl.Deletable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ExecutorExited;
import org.apache.spark.scheduler.ExecutorLossReason;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodState;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsLifecycleManager$$anonfun$org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshot;
import org.apache.spark.scheduler.cluster.k8s.ExecutorPodsSnapshotsStore;
import org.apache.spark.scheduler.cluster.k8s.FinalPodState;
import org.apache.spark.scheduler.cluster.k8s.KubernetesClusterSchedulerBackend;
import org.apache.spark.scheduler.cluster.k8s.KubernetesExecutorBuilder;
import org.apache.spark.scheduler.cluster.k8s.PodDeleted;
import org.apache.spark.scheduler.cluster.k8s.PodFailed;
import org.apache.spark.scheduler.cluster.k8s.PodSucceeded;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.spark_project.guava.cache.Cache;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0001\u0003\u0001!q!\u0001H#yK\u000e,Ho\u001c:Q_\u0012\u001cH*\u001b4fGf\u001cG.Z'b]\u0006<WM\u001d\u0006\u0003\u0007\u0011\t1a\u001b\u001dt\u0015\t)a!A\u0004dYV\u001cH/\u001a:\u000b\u0005\u001dA\u0011!C:dQ\u0016$W\u000f\\3s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u00051\u0011\r]1dQ\u0016T\u0011!D\u0001\u0004_J<7c\u0001\u0001\u0010+A\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0005\u0002\u0011%tG/\u001a:oC2L!AG\f\u0003\u000f1{wmZ5oO\"AA\u0004\u0001B\u0001B\u0003%a$\u0001\u0003d_:47\u0001\u0001\t\u0003?\u0001j\u0011\u0001C\u0005\u0003C!\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\nq\"\u001a=fGV$xN\u001d\"vS2$WM\u001d\t\u0003K\u0019j\u0011AA\u0005\u0003O\t\u0011\u0011dS;cKJtW\r^3t\u000bb,7-\u001e;pe\n+\u0018\u000e\u001c3fe\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\tlk\n,'O\\3uKN\u001cE.[3oiB\u00111\u0006N\u0007\u0002Y)\u0011QFL\u0001\u0007G2LWM\u001c;\u000b\u0005=\u0002\u0014AC6vE\u0016\u0014h.\u001a;fg*\u0011\u0011GM\u0001\bM\u0006\u0014'/[29\u0015\u0005\u0019\u0014AA5p\u0013\t)DF\u0001\tLk\n,'O\\3uKN\u001cE.[3oi\"Aq\u0007\u0001B\u0001B\u0003%\u0001(\u0001\bt]\u0006\u00048\u000f[8ugN#xN]3\u0011\u0005\u0015J\u0014B\u0001\u001e\u0003\u0005i)\u00050Z2vi>\u0014\bk\u001c3t':\f\u0007o\u001d5piN\u001cFo\u001c:f\u0011!a\u0004A!A!\u0002\u0013i\u0014!\u0006:f[>4X\rZ#yK\u000e,Ho\u001c:t\u0007\u0006\u001c\u0007.\u001a\t\u0005}\u001dK\u0015*D\u0001@\u0015\t\u0001\u0015)A\u0003dC\u000eDWM\u0003\u0002C\u0007\u000611m\\7n_:T!\u0001R#\u0002\r\u001d|wn\u001a7f\u0015\u00051\u0015aA2p[&\u0011\u0001j\u0010\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000bA\u0001\\1oO*\ta*\u0001\u0003kCZ\f\u0017B\u0001)L\u0005\u0011auN\\4\t\u000bI\u0003A\u0011A*\u0002\rqJg.\u001b;?)\u0019!VKV,Y3B\u0011Q\u0005\u0001\u0005\u00069E\u0003\rA\b\u0005\u0006GE\u0003\r\u0001\n\u0005\u0006SE\u0003\rA\u000b\u0005\u0006oE\u0003\r\u0001\u000f\u0005\u0006yE\u0003\r!\u0010\u0005\b7\u0002\u0011\r\u0011\"\u0003]\u0003])g/\u001a8u!J|7-Z:tS:<\u0017J\u001c;feZ\fG.F\u0001^!\t\u0001b,\u0003\u0002Q#!1\u0001\r\u0001Q\u0001\nu\u000b\u0001$\u001a<f]R\u0004&o\\2fgNLgnZ%oi\u0016\u0014h/\u00197!\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u0015\u0019H/\u0019:u)\t!w\r\u0005\u0002\u0011K&\u0011a-\u0005\u0002\u0005+:LG\u000fC\u0003iC\u0002\u0007\u0011.\u0001\ttG\",G-\u001e7fe\n\u000b7m[3oIB\u0011QE[\u0005\u0003W\n\u0011\u0011eS;cKJtW\r^3t\u00072,8\u000f^3s'\u000eDW\rZ;mKJ\u0014\u0015mY6f]\u0012DQ!\u001c\u0001\u0005\n9\fab\u001c8OK^\u001cf.\u00199tQ>$8\u000fF\u0002e_BDQ\u0001\u001b7A\u0002%DQ!\u001d7A\u0002I\f\u0011b\u001d8baNDw\u000e^:\u0011\u0007M\\hP\u0004\u0002us:\u0011Q\u000f_\u0007\u0002m*\u0011q/H\u0001\u0007yI|w\u000e\u001e \n\u0003II!A_\t\u0002\u000fA\f7m[1hK&\u0011A0 \u0002\u0004'\u0016\f(B\u0001>\u0012!\t)s0C\u0002\u0002\u0002\t\u0011A#\u0012=fGV$xN\u001d)pIN\u001cf.\u00199tQ>$\bbBA\u0003\u0001\u0011%\u0011qA\u0001\u0017_:4\u0015N\\1m\u001d>tG)\u001a7fi\u0016$7\u000b^1uKRIA-!\u0003\u0002\u0014\u0005]\u0011\u0011\u0004\u0005\t\u0003\u0017\t\u0019\u00011\u0001\u0002\u000e\u0005A\u0001o\u001c3Ti\u0006$X\rE\u0002&\u0003\u001fI1!!\u0005\u0003\u000551\u0015N\\1m!>$7\u000b^1uK\"9\u0011QCA\u0002\u0001\u0004i\u0016AB3yK\u000eLE\r\u0003\u0004i\u0003\u0007\u0001\r!\u001b\u0005\t\u00037\t\u0019\u00011\u0001\u0002\u001e\u0005)R\r_3d\u0013\u0012\u001c(+Z7pm\u0016$\u0017J\u001c*pk:$\u0007#BA\u0010\u0003SiVBAA\u0011\u0015\u0011\t\u0019#!\n\u0002\u000f5,H/\u00192mK*\u0019\u0011qE\t\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0005\u0005\"aA*fi\"9\u0011q\u0006\u0001\u0005\n\u0005E\u0012!\u0006:f[>4X-\u0012=fGV$xN\u001d$s_6\\\u0005h\u001d\u000b\u0004I\u0006M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\u0015U\u0004H-\u0019;fIB{G\r\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u000b5|G-\u001a7\u000b\u0007\u0005\u0005c&A\u0002ba&LA!!\u0012\u0002<\t\u0019\u0001k\u001c3\t\u000f\u0005%\u0003\u0001\"\u0003\u0002L\u00059\"/Z7pm\u0016,\u00050Z2vi>\u0014hI]8n'B\f'o\u001b\u000b\bI\u00065\u0013qJA)\u0011\u0019A\u0017q\ta\u0001S\"A\u00111BA$\u0001\u0004\ti\u0001C\u0004\u0002\u0016\u0005\u001d\u0003\u0019A/\t\u000f\u0005U\u0003\u0001\"\u0003\u0002X\u0005qa-\u001b8e\u000bbLGOU3bg>tGCBA-\u0003C\n\u0019\u0007\u0005\u0003\u0002\\\u0005uS\"\u0001\u0004\n\u0007\u0005}cA\u0001\bFq\u0016\u001cW\u000f^8s\u000bbLG/\u001a3\t\u0011\u0005-\u00111\u000ba\u0001\u0003\u001bAq!!\u0006\u0002T\u0001\u0007Q\fC\u0004\u0002h\u0001!I!!\u001b\u0002#\u0015D\u0018\u000e\u001e*fCN|g.T3tg\u0006<W\r\u0006\u0005\u0002l\u0005e\u00141PA?!\u0011\ti'a\u001d\u000f\u0007A\ty'C\u0002\u0002rE\ta\u0001\u0015:fI\u00164\u0017\u0002BA;\u0003o\u0012aa\u0015;sS:<'bAA9#!A\u00111BA3\u0001\u0004\ti\u0001C\u0004\u0002\u0016\u0005\u0015\u0004\u0019A/\t\u0011\u0005}\u0014Q\ra\u0001\u0003\u0003\u000b\u0001\"\u001a=ji\u000e{G-\u001a\t\u0004!\u0005\r\u0015bAAC#\t\u0019\u0011J\u001c;\t\u000f\u0005%\u0005\u0001\"\u0003\u0002\f\u0006aa-\u001b8e\u000bbLGoQ8eKR!\u0011\u0011QAG\u0011!\tY!a\"A\u0002\u00055qaBAI\u0005!%\u00111S\u0001\u001d\u000bb,7-\u001e;peB{Gm\u001d'jM\u0016\u001c\u0017p\u00197f\u001b\u0006t\u0017mZ3s!\r)\u0013Q\u0013\u0004\u0007\u0003\tAI!a&\u0014\u0007\u0005Uu\u0002C\u0004S\u0003+#\t!a'\u0015\u0005\u0005M\u0005BCAP\u0003+\u0013\r\u0011\"\u0001\u0002\"\u0006\tRKT&O\u001f^su,\u0012-J)~\u001bu\nR#\u0016\u0005\u0005\u0005\u0005\"CAS\u0003+\u0003\u000b\u0011BAA\u0003I)fj\u0013(P/:{V\tW%U?\u000e{E)\u0012\u0011")
public class ExecutorPodsLifecycleManager
implements Logging {
    public final KubernetesClient org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$kubernetesClient;
    private final ExecutorPodsSnapshotsStore snapshotsStore;
    public final Cache<Long, Long> org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removedExecutorsCache;
    private final long eventProcessingInterval;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static int UNKNOWN_EXIT_CODE() {
        return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private long eventProcessingInterval() {
        return this.eventProcessingInterval;
    }

    public void start(KubernetesClusterSchedulerBackend schedulerBackend) {
        this.snapshotsStore.addSubscriber(this.eventProcessingInterval(), (Function1<Seq<ExecutorPodsSnapshot>, BoxedUnit>)new Serializable(this, schedulerBackend){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManager $outer;
            private final KubernetesClusterSchedulerBackend schedulerBackend$1;

            public final void apply(Seq<ExecutorPodsSnapshot> x$1) {
                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$onNewSnapshots(this.schedulerBackend$1, x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.schedulerBackend$1 = schedulerBackend$1;
            }
        });
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$onNewSnapshots(KubernetesClusterSchedulerBackend schedulerBackend, Seq<ExecutorPodsSnapshot> snapshots) {
        HashSet execIdsRemovedInThisRound = HashSet$.MODULE$.empty();
        snapshots.foreach((Function1)new Serializable(this, schedulerBackend, execIdsRemovedInThisRound){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManager $outer;
            public final KubernetesClusterSchedulerBackend schedulerBackend$2;
            public final HashSet execIdsRemovedInThisRound$1;

            public final void apply(ExecutorPodsSnapshot snapshot) {
                snapshot.executorPods().foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$onNewSnapshots$1 $outer;

                    public final Object apply(Tuple2<Object, ExecutorPodState> x0$1) {
                        Tuple2<Object, ExecutorPodState> tuple2 = x0$1;
                        if (tuple2 != null) {
                            BoxedUnit boxedUnit;
                            long execId = tuple2._1$mcJ$sp();
                            ExecutorPodState state = (ExecutorPodState)tuple2._2();
                            ExecutorPodState executorPodState = state;
                            if (executorPodState instanceof PodDeleted) {
                                PodDeleted podDeleted = (PodDeleted)executorPodState;
                                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer().logDebug((Function0<String>)new Serializable(this, execId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final long execId$1;
                                    private final ExecutorPodState state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot reported deleted executor with id ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.execId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" pod name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state$1.pod().getMetadata().getName()}))).toString();
                                    }
                                    {
                                        this.execId$1 = execId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removeExecutorFromSpark(this.$outer.schedulerBackend$2, podDeleted, execId);
                                boxedUnit = this.$outer.execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
                            } else if (executorPodState instanceof PodFailed) {
                                PodFailed podFailed = (PodFailed)executorPodState;
                                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer().logDebug((Function0<String>)new Serializable(this, execId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final long execId$1;
                                    private final ExecutorPodState state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot reported failed executor with id ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.execId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" pod name ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state$1.pod().getMetadata().getName()}))).toString();
                                    }
                                    {
                                        this.execId$1 = execId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$onFinalNonDeletedState(podFailed, execId, this.$outer.schedulerBackend$2, (Set<Object>)this.$outer.execIdsRemovedInThisRound$1);
                                boxedUnit = BoxedUnit.UNIT;
                            } else if (executorPodState instanceof PodSucceeded) {
                                PodSucceeded podSucceeded = (PodSucceeded)executorPodState;
                                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer().logDebug((Function0<String>)new Serializable(this, execId, state){
                                    public static final long serialVersionUID = 0L;
                                    private final long execId$1;
                                    private final ExecutorPodState state$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Snapshot reported succeeded executor with id ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.execId$1)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" pod name ", ". Note that succeeded executors are"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.state$1.pod().getMetadata().getName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" unusual unless Spark specifically informed the executor to exit."})).s((Seq)Nil$.MODULE$)).toString();
                                    }
                                    {
                                        this.execId$1 = execId$1;
                                        this.state$1 = state$1;
                                    }
                                });
                                this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer().org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$onFinalNonDeletedState(podSucceeded, execId, this.$outer.schedulerBackend$2, (Set<Object>)this.$outer.execIdsRemovedInThisRound$1);
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return boxedUnit2;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ ExecutorPodsLifecycleManager org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.schedulerBackend$2 = schedulerBackend$2;
                this.execIdsRemovedInThisRound$1 = execIdsRemovedInThisRound$1;
            }
        });
        if (snapshots.nonEmpty()) {
            ExecutorPodsSnapshot latestSnapshot = (ExecutorPodsSnapshot)snapshots.last();
            ((IterableLike)((TraversableOnce)schedulerBackend.getExecutorIds().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final long apply(String x$2) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$2)).toLong();
                }
            }, Seq$.MODULE$.canBuildFrom())).toSet().$minus$minus((GenTraversableOnce)latestSnapshot.executorPods().keySet()).$minus$minus((GenTraversableOnce)execIdsRemovedInThisRound)).foreach((Function1)new Serializable(this, schedulerBackend, execIdsRemovedInThisRound){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ExecutorPodsLifecycleManager $outer;
                private final KubernetesClusterSchedulerBackend schedulerBackend$2;
                private final HashSet execIdsRemovedInThisRound$1;

                public final Object apply(long missingExecutorId) {
                    BoxedUnit boxedUnit;
                    if (this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)missingExecutorId)) == null) {
                        String exitReasonMessage2 = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The executor with ID ", " was not found in the"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)missingExecutorId)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" cluster but we didn't get a reason why. Marking the executor as failed. The"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" executor may have been deleted but the driver missed the deletion event."})).s((Seq)Nil$.MODULE$)).toString();
                        this.$outer.logDebug((Function0<String>)new Serializable(this, exitReasonMessage2){
                            public static final long serialVersionUID = 0L;
                            private final String exitReasonMessage$1;

                            public final String apply() {
                                return this.exitReasonMessage$1;
                            }
                            {
                                this.exitReasonMessage$1 = exitReasonMessage$1;
                            }
                        });
                        ExecutorExited exitReason = new ExecutorExited(ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE(), false, exitReasonMessage2);
                        this.schedulerBackend$2.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)missingExecutorId)).toString(), (ExecutorLossReason)exitReason);
                        boxedUnit = this.execIdsRemovedInThisRound$1.$plus$eq((Object)BoxesRunTime.boxToLong((long)missingExecutorId));
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return boxedUnit;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.schedulerBackend$2 = schedulerBackend$2;
                    this.execIdsRemovedInThisRound$1 = execIdsRemovedInThisRound$1;
                }
            });
        }
        if (execIdsRemovedInThisRound.nonEmpty()) {
            this.logDebug((Function0<String>)new Serializable(this, execIdsRemovedInThisRound){
                public static final long serialVersionUID = 0L;
                private final HashSet execIdsRemovedInThisRound$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removed executors with ids ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.execIdsRemovedInThisRound$1.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" from Spark that were either found to be deleted or non-existent in the cluster."})).s((Seq)Nil$.MODULE$)).toString();
                }
                {
                    this.execIdsRemovedInThisRound$1 = execIdsRemovedInThisRound$1;
                }
            });
        }
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$onFinalNonDeletedState(FinalPodState podState, long execId, KubernetesClusterSchedulerBackend schedulerBackend, Set<Object> execIdsRemovedInRound) {
        this.removeExecutorFromK8s(podState.pod());
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removeExecutorFromSpark(schedulerBackend, podState, execId);
        execIdsRemovedInRound.$plus$eq((Object)BoxesRunTime.boxToLong((long)execId));
    }

    private void removeExecutorFromK8s(Pod updatedPod) {
        Utils$.MODULE$.tryLogNonFatalError((Function0)new Serializable(this, updatedPod){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ExecutorPodsLifecycleManager $outer;
            private final Pod updatedPod$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                ((Deletable)this.$outer.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$kubernetesClient.pods().withName(this.updatedPod$1.getMetadata().getName())).delete();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.updatedPod$1 = updatedPod$1;
            }
        });
    }

    public void org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removeExecutorFromSpark(KubernetesClusterSchedulerBackend schedulerBackend, FinalPodState podState, long execId) {
        if (this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removedExecutorsCache.getIfPresent((Object)BoxesRunTime.boxToLong((long)execId)) == null) {
            this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removedExecutorsCache.put((Object)Predef$.MODULE$.long2Long(execId), (Object)Predef$.MODULE$.long2Long(execId));
            ExecutorExited exitReason = this.findExitReason(podState, execId);
            schedulerBackend.doRemoveExecutor(((Object)BoxesRunTime.boxToLong((long)execId)).toString(), (ExecutorLossReason)exitReason);
        }
    }

    private ExecutorExited findExitReason(FinalPodState podState, long execId) {
        Tuple2 tuple2;
        int exitCode = this.findExitCode(podState);
        FinalPodState finalPodState = podState;
        if (finalPodState instanceof PodDeleted) {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The executor with id ", " was deleted by a user or the framework."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)execId)})));
        } else {
            String msg = this.exitReasonMessage(podState, execId, exitCode);
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)msg);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 != null) {
            Tuple2 tuple23;
            boolean exitCausedByApp = tuple22._1$mcZ$sp();
            String exitMessage = (String)tuple22._2();
            Tuple2 tuple24 = tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)exitCausedByApp), (Object)exitMessage);
            boolean exitCausedByApp2 = tuple24._1$mcZ$sp();
            String exitMessage2 = (String)tuple24._2();
            return new ExecutorExited(exitCode, exitCausedByApp2, exitMessage2);
        }
        throw new MatchError((Object)tuple22);
    }

    private String exitReasonMessage(FinalPodState podState, long execId, int exitCode) {
        Pod pod = podState.pod();
        return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |The executor with id ", " exited with exit code ", ".\n       |The API gave the following brief reason: ", "\n       |The API gave the following message: ", "\n       |The API gave the following container statuses:\n       |\n       |", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)execId), BoxesRunTime.boxToInteger((int)exitCode), pod.getStatus().getReason(), pod.getStatus().getMessage(), ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(pod.getStatus().getContainerStatuses()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ContainerStatus x$4) {
                return x$4.toString();
            }
        }, Buffer$.MODULE$.canBuildFrom())).mkString("\n===\n")})))).stripMargin();
    }

    private int findExitCode(FinalPodState podState) {
        return BoxesRunTime.unboxToInt((Object)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(podState.pod().getStatus().getContainerStatuses()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ContainerStatus containerStatus) {
                return containerStatus.getState().getTerminated() != null;
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(ContainerStatus terminatedContainer) {
                return Predef$.MODULE$.Integer2int(terminatedContainer.getState().getTerminated().getExitCode());
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return ExecutorPodsLifecycleManager$.MODULE$.UNKNOWN_EXIT_CODE();
            }
        }));
    }

    public ExecutorPodsLifecycleManager(SparkConf conf, KubernetesExecutorBuilder executorBuilder, KubernetesClient kubernetesClient, ExecutorPodsSnapshotsStore snapshotsStore, Cache<Long, Long> removedExecutorsCache) {
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$kubernetesClient = kubernetesClient;
        this.snapshotsStore = snapshotsStore;
        this.org$apache$spark$scheduler$cluster$k8s$ExecutorPodsLifecycleManager$$removedExecutorsCache = removedExecutorsCache;
        Logging.class.$init$((Logging)this);
        this.eventProcessingInterval = BoxesRunTime.unboxToLong((Object)conf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_EVENT_PROCESSING_INTERVAL()));
    }
}

