/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ArrayJoin$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$;
import org.apache.spark.sql.catalyst.expressions.codegen.Block$BlockHelper$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprValue$;
import org.apache.spark.sql.catalyst.expressions.codegen.FalseLiteral$;
import org.apache.spark.sql.catalyst.expressions.codegen.UTF8StringBuilder;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(array, delimiter[, nullReplacement]) - Concatenates the elements of the given array\n      using the delimiter and an optional string to replace nulls. If no value is set for\n      nullReplacement, any null value is filtered.", examples="\n    Examples:\n      > SELECT _FUNC_(array('hello', 'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ');\n       hello world\n      > SELECT _FUNC_(array('hello', null ,'world'), ' ', ',');\n       hello , world\n  ", since="2.4.0")
@ScalaSignature(bytes="\u0006\u0001\tMa\u0001B\u0001\u0003\u0001>\u0011\u0011\"\u0011:sCfTu.\u001b8\u000b\u0005\r!\u0011aC3yaJ,7o]5p]NT!!\u0002\u0004\u0002\u0011\r\fG/\u00197zgRT!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\t\u0015/u\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002\u0012+%\u0011aC\u0001\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bC\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"a\u0002)s_\u0012,8\r\u001e\t\u00031yI!aH\r\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\nQ!\u0019:sCf,\u0012\u0001\u0005\u0005\tI\u0001\u0011\t\u0012)A\u0005!\u00051\u0011M\u001d:bs\u0002B\u0001B\n\u0001\u0003\u0016\u0004%\tAI\u0001\nI\u0016d\u0017.\\5uKJD\u0001\u0002\u000b\u0001\u0003\u0012\u0003\u0006I\u0001E\u0001\u000bI\u0016d\u0017.\\5uKJ\u0004\u0003\u0002\u0003\u0016\u0001\u0005+\u0007I\u0011A\u0016\u0002\u001f9,H\u000e\u001c*fa2\f7-Z7f]R,\u0012\u0001\f\t\u000415\u0002\u0012B\u0001\u0018\u001a\u0005\u0019y\u0005\u000f^5p]\"A\u0001\u0007\u0001B\tB\u0003%A&\u0001\tok2d'+\u001a9mC\u000e,W.\u001a8uA!)!\u0007\u0001C\u0001g\u00051A(\u001b8jiz\"B\u0001N\u001b7oA\u0011\u0011\u0003\u0001\u0005\u0006CE\u0002\r\u0001\u0005\u0005\u0006ME\u0002\r\u0001\u0005\u0005\u0006UE\u0002\r\u0001\f\u0005\u0006e\u0001!\t!\u000f\u000b\u0004iiZ\u0004\"B\u00119\u0001\u0004\u0001\u0002\"\u0002\u00149\u0001\u0004\u0001\u0002\"\u0002\u001a\u0001\t\u0003iD\u0003\u0002\u001b?\u007f\u0001CQ!\t\u001fA\u0002AAQA\n\u001fA\u0002AAQA\u000b\u001fA\u0002AAQA\u0011\u0001\u0005B\r\u000b!\"\u001b8qkR$\u0016\u0010]3t+\u0005!\u0005cA#N!:\u0011ai\u0013\b\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013:\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u00051K\u0012a\u00029bG.\fw-Z\u0005\u0003\u001d>\u00131aU3r\u0015\ta\u0015\u0004\u0005\u0002R)6\t!K\u0003\u0002T\r\u0005)A/\u001f9fg&\u0011QK\u0015\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016DQa\u0016\u0001\u0005Ba\u000b\u0001b\u00195jY\u0012\u0014XM\\\u000b\u00023B\u0019Q)\u0014\t\t\u000bm\u0003A\u0011\t/\u0002\u00119,H\u000e\\1cY\u0016,\u0012!\u0018\t\u00031yK!aX\r\u0003\u000f\t{w\u000e\\3b]\")\u0011\r\u0001C!9\u0006Aam\u001c7eC\ndW\rC\u0003d\u0001\u0011\u0005C-\u0001\u0003fm\u0006dGCA3i!\tAb-\u0003\u0002h3\t\u0019\u0011I\\=\t\u000f%\u0014\u0007\u0013!a\u0001U\u0006)\u0011N\u001c9viB\u00111\u000e\\\u0007\u0002\t%\u0011Q\u000e\u0002\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003p\u0001\u0011E\u0003/A\u0005e_\u001e+gnQ8eKR\u0019\u0011o\u001e?\u0011\u0005I,X\"A:\u000b\u0005Q\u0014\u0011aB2pI\u0016<WM\\\u0005\u0003mN\u0014\u0001\"\u0012=qe\u000e{G-\u001a\u0005\u0006q:\u0004\r!_\u0001\u0004GRD\bC\u0001:{\u0013\tY8O\u0001\bD_\u0012,w-\u001a8D_:$X\r\u001f;\t\u000but\u0007\u0019A9\u0002\u0005\u00154\bBB@\u0001\t\u0013\t\t!A\u000ehK:\u001cu\u000eZ3G_J\f%O]1z\u0003:$G)\u001a7j[&$XM\u001d\u000b\t\u0003\u0007\t\t\"a\u0005\u0002\u0016A!\u0011QAA\u0006\u001d\rA\u0012qA\u0005\u0004\u0003\u0013I\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\u000e\u0005=!AB*ue&twMC\u0002\u0002\neAQ\u0001\u001f@A\u0002eDQ! @A\u0002EDq!a\u0006\u007f\u0001\u0004\tI\"\u0001\u0005ok2dWI^1m!-A\u00121DA\u0002\u0003\u0007\t\u0019!a\u0001\n\u0007\u0005u\u0011DA\u0005Gk:\u001cG/[8og!9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0005\u0005\u0015\u0002cA)\u0002(%\u0019\u0011\u0011\u0006*\u0003\u0011\u0011\u000bG/\u0019+za\u0016Dq!!\f\u0001\t\u0003\ny#\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"!a\u0001\t\u0013\u0005M\u0002!!A\u0005\u0002\u0005U\u0012\u0001B2paf$r\u0001NA\u001c\u0003s\tY\u0004\u0003\u0005\"\u0003c\u0001\n\u00111\u0001\u0011\u0011!1\u0013\u0011\u0007I\u0001\u0002\u0004\u0001\u0002\u0002\u0003\u0016\u00022A\u0005\t\u0019\u0001\u0017\t\u0013\u0005}\u0002!%A\u0005\u0002\u0005\u0005\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007R3\u0001EA#W\t\t9\u0005\u0005\u0003\u0002J\u0005MSBAA&\u0015\u0011\ti%a\u0014\u0002\u0013Ut7\r[3dW\u0016$'bAA)3\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00131\n\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA-\u0001E\u0005I\u0011AA!\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!\u0018\u0001#\u0003%\t!a\u0018\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011\u0011\r\u0016\u0004Y\u0005\u0015\u0003\"CA3\u0001\u0005\u0005I\u0011IA4\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011\u0011\u000e\t\u0005\u0003W\n)(\u0004\u0002\u0002n)!\u0011qNA9\u0003\u0011a\u0017M\\4\u000b\u0005\u0005M\u0014\u0001\u00026bm\u0006LA!!\u0004\u0002n!I\u0011\u0011\u0010\u0001\u0002\u0002\u0013\u0005\u00111P\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003{\u00022\u0001GA@\u0013\r\t\t)\u0007\u0002\u0004\u0013:$\b\"CAC\u0001\u0005\u0005I\u0011AAD\u00039\u0001(o\u001c3vGR,E.Z7f]R$2!ZAE\u0011)\tY)a!\u0002\u0002\u0003\u0007\u0011QP\u0001\u0004q\u0012\n\u0004\"CAH\u0001\u0005\u0005I\u0011IAI\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAJ!\u0015\t)*a'f\u001b\t\t9JC\u0002\u0002\u001af\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\ti*a&\u0003\u0011%#XM]1u_JD\u0011\"!)\u0001\u0003\u0003%\t!a)\u0002\u0011\r\fg.R9vC2$2!XAS\u0011%\tY)a(\u0002\u0002\u0003\u0007Q\rC\u0005\u0002*\u0002\t\t\u0011\"\u0011\u0002,\u00061Q-];bYN$2!XAW\u0011%\tY)a*\u0002\u0002\u0003\u0007Q\rK\b\u0001\u0003c\u000b9,!/\u0002>\u0006}\u00161YAc!\r\t\u00121W\u0005\u0004\u0003k\u0013!!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003w\u000b\u0011\u0011\u001c\u0006!A\u0001\u0002sLR+O\u0007~C\u0013M\u001d:bs2\u0002C-\u001a7j[&$XM].-A9,H\u000e\u001c*fa2\f7-Z7f]Rl\u0016\u0006I\u0017!\u0007>t7-\u0019;f]\u0006$Xm\u001d\u0011uQ\u0016\u0004S\r\\3nK:$8\u000fI8gAQDW\rI4jm\u0016t\u0007%\u0019:sCfT\u0001\u0005\t\u0011!A\u0001*8/\u001b8hAQDW\r\t3fY&l\u0017\u000e^3sA\u0005tG\rI1oA=\u0004H/[8oC2\u00043\u000f\u001e:j]\u001e\u0004Co\u001c\u0011sKBd\u0017mY3!]VdGn\u001d\u0018!\u0013\u001a\u0004cn\u001c\u0011wC2,X\rI5tAM,G\u000f\t4pe*\u0001\u0003\u0005\t\u0011!A9,H\u000e\u001c*fa2\f7-Z7f]Rd\u0003%\u00198zA9,H\u000e\u001c\u0011wC2,X\rI5tA\u0019LG\u000e^3sK\u0012t\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005\u0005\u0017!!?\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O!,G\u000e\\8(Y\u0001:so\u001c:mI\u001eJC\u0006I\u0014!O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005[3mY>\u0004so\u001c:mI*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~C\u0013M\u001d:bs\":\u0003.\u001a7m_\u001eb\u0003E\\;mY\u0002bse^8sY\u0012<\u0013\u0006\f\u0011(A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t5fY2|\u0007e^8sY\u0012T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\u0019:sCfDs\u0005[3mY><C\u0006\t8vY2\u0004CfJ<pe2$w%\u000b\u0017!O\u0001:C\u0006I\u0014-O%Z$\u0002\t\u0011!A\u0001\u0002\u0003\u0005[3mY>\u0004C\u0006I<pe2$'\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005\u001d\u0017!\u0002\u001a/i9\u0002t!CAf\u0005\u0005\u0005\t\u0012AAg\u0003%\t%O]1z\u0015>Lg\u000eE\u0002\u0012\u0003\u001f4\u0001\"\u0001\u0002\u0002\u0002#\u0005\u0011\u0011[\n\u0006\u0003\u001f\f\u0019.\b\t\t\u0003+\fY\u000e\u0005\t-i5\u0011\u0011q\u001b\u0006\u0004\u00033L\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003;\f9NA\tBEN$(/Y2u\rVt7\r^5p]NBqAMAh\t\u0003\t\t\u000f\u0006\u0002\u0002N\"Q\u0011Q]Ah\u0003\u0003%)%a:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!!\u001b\t\u0015\u0005-\u0018qZA\u0001\n\u0003\u000bi/A\u0003baBd\u0017\u0010F\u00045\u0003_\f\t0a=\t\r\u0005\nI\u000f1\u0001\u0011\u0011\u00191\u0013\u0011\u001ea\u0001!!1!&!;A\u00021B!\"a>\u0002P\u0006\u0005I\u0011QA}\u0003\u001d)h.\u00199qYf$B!a?\u0003\u0004A!\u0001$LA\u007f!\u0019A\u0012q \t\u0011Y%\u0019!\u0011A\r\u0003\rQ+\b\u000f\\34\u0011%\u0011)!!>\u0002\u0002\u0003\u0007A'A\u0002yIAB!B!\u0003\u0002P\u0006\u0005I\u0011\u0002B\u0006\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t5\u0001\u0003BA6\u0005\u001fIAA!\u0005\u0002n\t1qJ\u00196fGR\u0004")
public class ArrayJoin
extends Expression
implements ExpectsInputTypes,
Serializable {
    private final Expression array;
    private final Expression delimiter;
    private final Option<Expression> nullReplacement;

    public static Option<Tuple3<Expression, Expression, Option<Expression>>> unapply(ArrayJoin arrayJoin) {
        return ArrayJoin$.MODULE$.unapply(arrayJoin);
    }

    public static Function1<Tuple3<Expression, Expression, Option<Expression>>, ArrayJoin> tupled() {
        return ArrayJoin$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Option<Expression>, ArrayJoin>>> curried() {
        return ArrayJoin$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes$class.checkInputDataTypes(this);
    }

    public Expression array() {
        return this.array;
    }

    public Expression delimiter() {
        return this.delimiter;
    }

    public Option<Expression> nullReplacement() {
        return this.nullReplacement;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return this.nullReplacement().isDefined() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{ArrayType$.MODULE$.apply(StringType$.MODULE$), StringType$.MODULE$, StringType$.MODULE$})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DataType[]{ArrayType$.MODULE$.apply(StringType$.MODULE$), StringType$.MODULE$}));
    }

    @Override
    public Seq<Expression> children() {
        return this.nullReplacement().isDefined() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.array(), this.delimiter(), (Expression)this.nullReplacement().get()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.array(), this.delimiter()}));
    }

    @Override
    public boolean nullable() {
        return this.children().exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$32) {
                return x$32.nullable();
            }
        });
    }

    @Override
    public boolean foldable() {
        return this.children().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$33) {
                return x$33.foldable();
            }
        });
    }

    @Override
    public Object eval(InternalRow input) {
        Option option;
        block8: {
            Object object;
            BooleanRef firstItem;
            UTF8StringBuilder buffer;
            Object delimiterEval;
            Object arrayEval;
            block7: {
                block6: {
                    arrayEval = this.array().eval(input);
                    if (arrayEval == null) {
                        return null;
                    }
                    delimiterEval = this.delimiter().eval(input);
                    if (delimiterEval == null) {
                        return null;
                    }
                    Option nullReplacementEval = this.nullReplacement().map((Function1)new Serializable(this, input){
                        public static final long serialVersionUID = 0L;
                        private final InternalRow input$3;

                        public final Object apply(Expression x$34) {
                            return x$34.eval(this.input$3);
                        }
                        {
                            this.input$3 = input$3;
                        }
                    });
                    if (nullReplacementEval.contains(null)) {
                        return null;
                    }
                    buffer = new UTF8StringBuilder();
                    firstItem = BooleanRef.create((boolean)true);
                    option = nullReplacementEval;
                    if (!(option instanceof Some)) break block6;
                    Some some = (Some)option;
                    Object rep = some.x();
                    object = new Serializable(this, delimiterEval, buffer, rep){
                        public static final long serialVersionUID = 0L;
                        private final Object delimiterEval$1;
                        private final UTF8StringBuilder buffer$1;
                        private final Object rep$1;

                        public final boolean apply(boolean prependDelimiter) {
                            if (!prependDelimiter) {
                                this.buffer$1.append((UTF8String)this.delimiterEval$1);
                            }
                            this.buffer$1.append((UTF8String)this.rep$1);
                            return true;
                        }
                        {
                            this.delimiterEval$1 = delimiterEval$1;
                            this.buffer$1 = buffer$1;
                            this.rep$1 = rep$1;
                        }
                    };
                    break block7;
                }
                if (!None$.MODULE$.equals(option)) break block8;
                object = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(boolean x$35) {
                        return false;
                    }
                };
            }
            Serializable nullHandling = object;
            ((ArrayData)arrayEval).foreach(StringType$.MODULE$, (Function2<Object, Object, BoxedUnit>)new Serializable(this, delimiterEval, buffer, firstItem, (Function1)nullHandling){
                public static final long serialVersionUID = 0L;
                private final Object delimiterEval$1;
                private final UTF8StringBuilder buffer$1;
                private final BooleanRef firstItem$1;
                private final Function1 nullHandling$1;

                public final void apply(int x$36, Object item) {
                    if (item == null) {
                        if (BoxesRunTime.unboxToBoolean((Object)this.nullHandling$1.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.firstItem$1.elem)))) {
                            this.firstItem$1.elem = false;
                        }
                    } else {
                        if (!this.firstItem$1.elem) {
                            this.buffer$1.append((UTF8String)this.delimiterEval$1);
                        }
                        this.buffer$1.append((UTF8String)item);
                        this.firstItem$1.elem = false;
                    }
                }
                {
                    this.delimiterEval$1 = delimiterEval$1;
                    this.buffer$1 = buffer$1;
                    this.firstItem$1 = firstItem$1;
                    this.nullHandling$1 = nullHandling$1;
                }
            });
            return buffer.build();
        }
        throw new MatchError((Object)option);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        Option<Expression> option;
        block4: {
            String string;
            block3: {
                block2: {
                    option = this.nullReplacement();
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    Expression replacement = (Expression)some.x();
                    ExprCode replacementGen = replacement.genCode(ctx);
                    Serializable nullHandling = new Serializable(this, replacementGen){
                        public static final long serialVersionUID = 0L;
                        private final ExprCode replacementGen$1;

                        public final String apply(String buffer, String delimiter, String firstItem) {
                            return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |if (!", ") {\n             |  ", ".append(", ");\n             |}\n             |", ".append(", ");\n             |", " = false;\n           "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstItem, buffer, delimiter, buffer, this.replacementGen$1.value(), firstItem})))).stripMargin();
                        }
                        {
                            this.replacementGen$1 = replacementGen$1;
                        }
                    };
                    String execCode = replacement.nullable() ? ctx.nullSafeExec(replacement.nullable(), ExprValue$.MODULE$.exprValueToString(replacementGen.isNull()), this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling)) : this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)nullHandling);
                    string = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |", "\n           |", "\n         "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{replacementGen.code(), execCode})))).stripMargin();
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                string = this.genCodeForArrayAndDelimiter(ctx, ev, (Function3<String, String, String, String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$37, String x$38, String x$39) {
                        return "// nulls are ignored";
                    }
                });
            }
            String code2 = string;
            return this.nullable() ? ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |boolean ", " = true;\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), ev.value(), code2})).stripMargin(), ev.copy$default$2(), ev.copy$default$3()) : ev.copy(Block$BlockHelper$.MODULE$.code$extension(Block$.MODULE$.BlockHelper(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n           |UTF8String ", " = null;\n           |", "\n         "}))), (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.value(), code2})).stripMargin(), FalseLiteral$.MODULE$, ev.copy$default$3());
        }
        throw new MatchError(option);
    }

    private String genCodeForArrayAndDelimiter(CodegenContext ctx, ExprCode ev, Function3<String, String, String, String> nullEval) {
        ExprCode arrayGen = this.array().genCode(ctx);
        ExprCode delimiterGen = this.delimiter().genCode(ctx);
        String buffer = ctx.freshName("buffer");
        String bufferClass = UTF8StringBuilder.class.getName();
        String i = ctx.freshName("i");
        String firstItem = ctx.freshName("firstItem");
        String resultCode = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", " ", " = new ", "();\n         |boolean ", " = true;\n         |for (int ", " = 0; ", " < ", ".numElements(); ", " ++) {\n         |  if (", ".isNullAt(", ")) {\n         |    ", "\n         |  } else {\n         |    if (!", ") {\n         |      ", ".append(", ");\n         |    }\n         |    ", ".append(", ");\n         |    ", " = false;\n         |  }\n         |}\n         |", " = ", ".build();"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{bufferClass, buffer, bufferClass, firstItem, i, i, arrayGen.value(), i, arrayGen.value(), i, nullEval.apply((Object)buffer, (Object)ExprValue$.MODULE$.exprValueToString(delimiterGen.value()), (Object)firstItem), firstItem, buffer, delimiterGen.value(), buffer, CodeGenerator$.MODULE$.getValue(ExprValue$.MODULE$.exprValueToString(arrayGen.value()), StringType$.MODULE$, i), firstItem, ev.value(), buffer})))).stripMargin();
        return this.array().nullable() || this.delimiter().nullable() ? Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)arrayGen.code()), ctx.nullSafeExec(this.array().nullable(), ExprValue$.MODULE$.exprValueToString(arrayGen.isNull()), Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)delimiterGen.code()), ctx.nullSafeExec(this.delimiter().nullable(), ExprValue$.MODULE$.exprValueToString(delimiterGen.isNull()), new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |", " = false;\n             |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{ev.isNull(), resultCode})))).stripMargin())))) : new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |", "\n         |", "\n         |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arrayGen.code(), delimiterGen.code(), resultCode})))).stripMargin();
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "array_join";
    }

    public ArrayJoin copy(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        return new ArrayJoin(array, delimiter, nullReplacement);
    }

    public Expression copy$default$1() {
        return this.array();
    }

    public Expression copy$default$2() {
        return this.delimiter();
    }

    public Option<Expression> copy$default$3() {
        return this.nullReplacement();
    }

    @Override
    public String productPrefix() {
        return "ArrayJoin";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 2: {
                object = this.nullReplacement();
                break;
            }
            case 1: {
                object = this.delimiter();
                break;
            }
            case 0: {
                object = this.array();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArrayJoin;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArrayJoin)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArrayJoin arrayJoin = (ArrayJoin)x$1;
        Expression expression = this.array();
        Expression expression2 = arrayJoin.array();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.delimiter();
        Expression expression4 = arrayJoin.delimiter();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Option<Expression> option = this.nullReplacement();
        Option<Expression> option2 = arrayJoin.nullReplacement();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!arrayJoin.canEqual(this)) return false;
        return true;
    }

    public ArrayJoin(Expression array, Expression delimiter, Option<Expression> nullReplacement) {
        this.array = array;
        this.delimiter = delimiter;
        this.nullReplacement = nullReplacement;
        ExpectsInputTypes$class.$init$(this);
    }

    public ArrayJoin(Expression array, Expression delimiter) {
        this(array, delimiter, (Option<Expression>)None$.MODULE$);
    }

    public ArrayJoin(Expression array, Expression delimiter, Expression nullReplacement) {
        this(array, delimiter, (Option<Expression>)new Some((Object)nullReplacement));
    }
}

