/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions.aggregate;

import java.nio.ByteBuffer;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes$class;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile$;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.catalyst.util.QuantileSummaries;
import org.apache.spark.sql.catalyst.util.QuantileSummaries$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NumericType;
import org.apache.spark.sql.types.NumericType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.TypeCollection$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(col, percentage [, accuracy]) - Returns the approximate percentile value of numeric\n      column `col` at the given percentage. The value of percentage must be between 0.0\n      and 1.0. The `accuracy` parameter (default: 10000) is a positive numeric literal which\n      controls approximation accuracy at the cost of memory. Higher value of `accuracy` yields\n      better accuracy, `1.0/accuracy` is the relative error of the approximation.\n      When `percentage` is an array, each value of the percentage array must be between 0.0 and 1.0.\n      In this case, returns the approximate percentile array of column `col` at the given\n      percentage array.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_(10.0, array(0.5, 0.4, 0.1), 100);\n       [10.0,10.0,10.0]\n      > SELECT _FUNC_(10.0, 0.5, 100);\n       10.0\n  ")
@ScalaSignature(bytes="\u0006\u0001\rmb\u0001B\u0001\u0003\u0001F\u0011Q#\u00119qe>D\u0018.\\1uKB+'oY3oi&dWM\u0003\u0002\u0004\t\u0005I\u0011mZ4sK\u001e\fG/\u001a\u0006\u0003\u000b\u0019\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011q\u0001C\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M9\u0001AEAG\u0003'#\u0004cA\n\u0015-5\t!!\u0003\u0002\u0016\u0005\tAB+\u001f9fI&k\u0007/\u001a:bi&4X-Q4he\u0016<\u0017\r^3\u0011\u0005]\u0011eB\u0001\r*\u001d\tI\u0002F\u0004\u0002\u001bO9\u00111D\n\b\u00039\u0015r!!\b\u0013\u000f\u0005y\u0019cBA\u0010#\u001b\u0005\u0001#BA\u0011\u0011\u0003\u0019a$o\\8u}%\tq\"\u0003\u0002\u000e\u001d%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u000f\u0015Q#\u0001#\u0001,\u0003U\t\u0005\u000f\u001d:pq&l\u0017\r^3QKJ\u001cWM\u001c;jY\u0016\u0004\"a\u0005\u0017\u0007\u000b\u0005\u0011\u0001\u0012A\u0017\u0014\u00071rC\u0007\u0005\u00020e5\t\u0001GC\u00012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0004G\u0001\u0004B]f\u0014VM\u001a\t\u0003_UJ!A\u000e\u0019\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000babC\u0011A\u001d\u0002\rqJg.\u001b;?)\u0005Y\u0003bB\u001e-\u0005\u0004%\t\u0001P\u0001\u001c\t\u00163\u0015)\u0016'U?B+%kQ#O)&cUiX!D\u0007V\u0013\u0016iQ-\u0016\u0003u\u0002\"a\f \n\u0005}\u0002$aA%oi\"1\u0011\t\fQ\u0001\nu\nA\u0004R#G\u0003VcEk\u0018)F%\u000e+e\nV%M\u000b~\u000b5iQ+S\u0003\u000eK\u0006E\u0002\u0003DY\u0001!%\u0001\u0005)fe\u000e,g\u000e^5mK\u0012Kw-Z:u'\t\u0011e\u0006\u0003\u0005G\u0005\n\u0005\r\u0011\"\u0003H\u0003%\u0019X/\\7be&,7/F\u0001I!\tIE*D\u0001K\u0015\tYe!\u0001\u0003vi&d\u0017BA'K\u0005E\tV/\u00198uS2,7+^7nCJLWm\u001d\u0005\t\u001f\n\u0013\t\u0019!C\u0005!\u0006i1/^7nCJLWm]0%KF$\"!\u0015+\u0011\u0005=\u0012\u0016BA*1\u0005\u0011)f.\u001b;\t\u000fUs\u0015\u0011!a\u0001\u0011\u0006\u0019\u0001\u0010J\u0019\t\u0011]\u0013%\u0011!Q!\n!\u000b!b];n[\u0006\u0014\u0018.Z:!\u0011\u0015A$\t\"\u0001Z)\tQF\f\u0005\u0002\\\u00056\tA\u0006C\u0003G1\u0002\u0007\u0001\nC\u00039\u0005\u0012\u0005a\f\u0006\u0002[?\")\u0001-\u0018a\u0001C\u0006i!/\u001a7bi&4X-\u0012:s_J\u0004\"a\f2\n\u0005\r\u0004$A\u0002#pk\ndW\r\u0003\u0004f\u0005\u0012\u0005\u0001BZ\u0001\rSN\u001cu.\u001c9sKN\u001cX\rZ\u000b\u0002OB\u0011q\u0006[\u0005\u0003SB\u0012qAQ8pY\u0016\fg\u000eC\u0003l\u0005\u0012\u0005q)A\trk\u0006tG/\u001b7f'VlW.\u0019:jKNDQ!\u001c\"\u0005\u00029\f1!\u00193e)\t\tv\u000eC\u0003qY\u0002\u0007\u0011-A\u0003wC2,X\rC\u0003s\u0005\u0012\u00051/A\u0003nKJ<W\r\u0006\u0002Ri\")Q/\u001da\u00015\u0006)q\u000e\u001e5fe\")qO\u0011C\u0001q\u0006qq-\u001a;QKJ\u001cWM\u001c;jY\u0016\u001cHCA=}!\ry#0Y\u0005\u0003wB\u0012Q!\u0011:sCfDQ! <A\u0002e\f1\u0002]3sG\u0016tG/Y4fg\"1qP\u0011C\u0007\u0003\u0003\t\u0001bY8naJ,7o\u001d\u000b\u0002#\u001a1\u0011Q\u0001\u0017\u0001\u0003\u000f\u0011!\u0004U3sG\u0016tG/\u001b7f\t&<Wm\u001d;TKJL\u0017\r\\5{KJ\u001c2!a\u0001/\u0011\u001dA\u00141\u0001C\u0001\u0003\u0017!\"!!\u0004\u0011\u0007m\u000b\u0019\u0001\u0003\u0005\u0002\u0012\u0005\rAQBA\n\u0003\u0019aWM\\4uQR\u0019Q(!\u0006\t\r\u0019\u000by\u00011\u0001I\u0011!\tI\"a\u0001\u0005\u0006\u0005m\u0011!C:fe&\fG.\u001b>f)\u0011\ti\"!\n\u0011\t=R\u0018q\u0004\t\u0004_\u0005\u0005\u0012bAA\u0012a\t!!)\u001f;f\u0011\u001d\t9#a\u0006A\u0002i\u000b1a\u001c2k\u0011!\tY#a\u0001\u0005\u0006\u00055\u0012a\u00033fg\u0016\u0014\u0018.\u00197ju\u0016$2AWA\u0018\u0011!\t\t$!\u000bA\u0002\u0005u\u0011!\u00022zi\u0016\u001c\b\"CA\u001bY\t\u0007I\u0011AA\u001c\u0003)\u0019XM]5bY&TXM]\u000b\u0003\u0003\u001bA\u0001\"a\u000f-A\u0003%\u0011QB\u0001\fg\u0016\u0014\u0018.\u00197ju\u0016\u0014\b\u0005C\u0005\u0002@1\n\t\u0011\"!\u0002B\u0005)\u0011\r\u001d9msRa\u00111IA#\u0003#\n)&!\u0017\u0002^A\u00111\u0003\u0001\u0005\t\u0003\u000f\ni\u00041\u0001\u0002J\u0005)1\r[5mIB!\u00111JA'\u001b\u0005!\u0011bAA(\t\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\t\u0011\u0005M\u0013Q\ba\u0001\u0003\u0013\nA\u0003]3sG\u0016tG/Y4f\u000bb\u0004(/Z:tS>t\u0007\u0002CA,\u0003{\u0001\r!!\u0013\u0002%\u0005\u001c7-\u001e:bGf,\u0005\u0010\u001d:fgNLwN\u001c\u0005\b\u00037\ni\u00041\u0001>\u0003YiW\u000f^1cY\u0016\fum\u001a\"vM\u001a,'o\u00144gg\u0016$\bbBA0\u0003{\u0001\r!P\u0001\u0015S:\u0004X\u000f^!hO\n+hMZ3s\u001f\u001a47/\u001a;\t\u0013\u0005\rD&!A\u0005\u0002\u0006\u0015\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0003O\n\u0019\bE\u00030\u0003S\ni'C\u0002\u0002lA\u0012aa\u00149uS>t\u0007cC\u0018\u0002p\u0005%\u0013\u0011JA%{uJ1!!\u001d1\u0005\u0019!V\u000f\u001d7fk!Q\u0011QOA1\u0003\u0003\u0005\r!a\u0011\u0002\u0007a$\u0003\u0007C\u0005\u0002z1\n\t\u0011\"\u0003\u0002|\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ti\b\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\t1\fgn\u001a\u0006\u0003\u0003\u000f\u000bAA[1wC&!\u00111RAA\u0005\u0019y%M[3diB!\u00111JAH\u0013\r\t\t\n\u0002\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0019q&!&\n\u0007\u0005]\u0005GA\u0004Qe>$Wo\u0019;\t\u0015\u0005\u001d\u0003A!f\u0001\n\u0003\tY*\u0006\u0002\u0002J!Q\u0011q\u0014\u0001\u0003\u0012\u0003\u0006I!!\u0013\u0002\r\rD\u0017\u000e\u001c3!\u0011)\t\u0019\u0006\u0001BK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003K\u0003!\u0011#Q\u0001\n\u0005%\u0013!\u00069fe\u000e,g\u000e^1hK\u0016C\bO]3tg&|g\u000e\t\u0005\u000b\u0003/\u0002!Q3A\u0005\u0002\u0005m\u0005BCAV\u0001\tE\t\u0015!\u0003\u0002J\u0005\u0019\u0012mY2ve\u0006\u001c\u00170\u0012=qe\u0016\u001c8/[8oA!I\u00111\f\u0001\u0003\u0016\u0004%\t\u0005\u0010\u0005\n\u0003c\u0003!\u0011#Q\u0001\nu\nq#\\;uC\ndW-Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u0011\t\u0013\u0005}\u0003A!f\u0001\n\u0003b\u0004\"CA\\\u0001\tE\t\u0015!\u0003>\u0003UIg\u000e];u\u0003\u001e<')\u001e4gKJ|eMZ:fi\u0002Ba\u0001\u000f\u0001\u0005\u0002\u0005mF\u0003DA\"\u0003{\u000by,!1\u0002D\u0006\u0015\u0007\u0002CA$\u0003s\u0003\r!!\u0013\t\u0011\u0005M\u0013\u0011\u0018a\u0001\u0003\u0013B\u0001\"a\u0016\u0002:\u0002\u0007\u0011\u0011\n\u0005\b\u00037\nI\f1\u0001>\u0011\u001d\ty&!/A\u0002uBa\u0001\u000f\u0001\u0005\u0002\u0005%G\u0003CA\"\u0003\u0017\fi-a4\t\u0011\u0005\u001d\u0013q\u0019a\u0001\u0003\u0013B\u0001\"a\u0015\u0002H\u0002\u0007\u0011\u0011\n\u0005\t\u0003/\n9\r1\u0001\u0002J!1\u0001\b\u0001C\u0001\u0003'$b!a\u0011\u0002V\u0006]\u0007\u0002CA$\u0003#\u0004\r!!\u0013\t\u0011\u0005M\u0013\u0011\u001ba\u0001\u0003\u0013B\u0011\"a7\u0001\u0011\u000b\u0007I\u0011\u0002\u001f\u0002\u0011\u0005\u001c7-\u001e:bGfD\u0011\"a8\u0001\u0011\u0003\u0005\u000b\u0015B\u001f\u0002\u0013\u0005\u001c7-\u001e:bGf\u0004\u0003bBAr\u0001\u0011\u0005\u0013Q]\u0001\u000bS:\u0004X\u000f\u001e+za\u0016\u001cXCAAt!\u0019\tI/a=\u0002z:!\u00111^Ax\u001d\ry\u0012Q^\u0005\u0002c%\u0019\u0011\u0011\u001f\u0019\u0002\u000fA\f7m[1hK&!\u0011Q_A|\u0005\r\u0019V-\u001d\u0006\u0004\u0003c\u0004\u0004\u0003BA~\u0005\u0003i!!!@\u000b\u0007\u0005}\b\"A\u0003usB,7/\u0003\u0003\u0003\u0004\u0005u(\u0001E!cgR\u0014\u0018m\u0019;ECR\fG+\u001f9f\u0011-)\u0006\u0001%A\t\b\u0004&IAa\u0002\u0016\u0005\t%\u0001#B\u0018\u0003\f\u001dL\u0018b\u0001B\u0007a\t1A+\u001e9mKJB!B!\u0005\u0001\u0011\u0003\u0005\u000b\u0015\u0002B\u0005\u0003\u0011AH%\r\u0011\t\u0013\tU\u0001\u0001#b\u0001\n\u00131\u0017!\u0006:fiV\u0014h\u000eU3sG\u0016tG/\u001b7f\u0003J\u0014\u0018-\u001f\u0005\n\u00053\u0001\u0001\u0012!Q!\n\u001d\faC]3ukJt\u0007+\u001a:dK:$\u0018\u000e\\3BeJ\f\u0017\u0010\t\u0005\n{\u0002A)\u0019!C\u0005\u0005;)\u0012!\u001f\u0005\n\u0005C\u0001\u0001\u0012!Q!\ne\fA\u0002]3sG\u0016tG/Y4fg\u0002BqA!\n\u0001\t\u0003\u00129#A\ndQ\u0016\u001c7.\u00138qkR$\u0015\r^1UsB,7\u000f\u0006\u0002\u0003*A!!1\u0006B\u0019\u001b\t\u0011iCC\u0002\u00030\u0019\t\u0001\"\u00198bYf\u001c\u0018n]\u0005\u0005\u0005g\u0011iCA\bUsB,7\t[3dWJ+7/\u001e7u\u0011\u001d\u00119\u0004\u0001C!\u0005s\tqc\u0019:fCR,\u0017iZ4sK\u001e\fG/[8o\u0005V4g-\u001a:\u0015\u0003YAqA!\u0010\u0001\t\u0003\u0012y$\u0001\u0004va\u0012\fG/\u001a\u000b\u0006-\t\u0005#Q\t\u0005\b\u0005\u0007\u0012Y\u00041\u0001\u0017\u0003\u0019\u0011WO\u001a4fe\"A!q\tB\u001e\u0001\u0004\u0011I%\u0001\u0005j]B,HOU8x!\u0011\u0011YE!\u0014\u000e\u0003\u0019I1Aa\u0014\u0007\u0005-Ie\u000e^3s]\u0006d'k\\<\t\rI\u0004A\u0011\tB*)\u00151\"Q\u000bB,\u0011\u001d\u0011\u0019E!\u0015A\u0002YAa!\u001eB)\u0001\u00041\u0002b\u0002B.\u0001\u0011\u0005#QL\u0001\u0005KZ\fG\u000e\u0006\u0003\u0003`\t\u0015\u0004cA\u0018\u0003b%\u0019!1\r\u0019\u0003\u0007\u0005s\u0017\u0010C\u0004\u0003D\te\u0003\u0019\u0001\f\t\u000f\t%\u0004\u0001\"\u0011\u0003l\u0005ir/\u001b;i\u001d\u0016<X*\u001e;bE2,\u0017iZ4Ck\u001a4WM](gMN,G\u000f\u0006\u0003\u0002D\t5\u0004b\u0002B8\u0005O\u0002\r!P\u0001\n]\u0016<xJ\u001a4tKRDqAa\u001d\u0001\t\u0003\u0012)(A\u000exSRDg*Z<J]B,H/Q4h\u0005V4g-\u001a:PM\u001a\u001cX\r\u001e\u000b\u0005\u0003\u0007\u00129\bC\u0004\u0003p\tE\u0004\u0019A\u001f\t\u000f\tm\u0004\u0001\"\u0011\u0003~\u0005A1\r[5mIJ,g.\u0006\u0002\u0003\u0000A1\u0011\u0011^Az\u0003\u0013BaAa!\u0001\t\u00032\u0017\u0001\u00038vY2\f'\r\\3\t\u000f\t\u001d\u0005\u0001\"\u0011\u0003\n\u0006AA-\u0019;b)f\u0004X-\u0006\u0002\u0003\fB!\u00111 BG\u0013\u0011\u0011y)!@\u0003\u0011\u0011\u000bG/\u0019+za\u0016DqAa%\u0001\t\u0003\u0012)*\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\"Aa&\u0011\t\te%q\u0014\b\u0004_\tm\u0015b\u0001BOa\u00051\u0001K]3eK\u001aLAA!)\u0003$\n11\u000b\u001e:j]\u001eT1A!(1\u0011\u001d\tI\u0002\u0001C!\u0005O#B!!\b\u0003*\"9\u0011q\u0005BS\u0001\u00041\u0002bBA\u0016\u0001\u0011\u0005#Q\u0016\u000b\u0004-\t=\u0006\u0002CA\u0019\u0005W\u0003\r!!\b\t\u0013\tM\u0006!!A\u0005\u0002\tU\u0016\u0001B2paf$B\"a\u0011\u00038\ne&1\u0018B_\u0005\u007fC!\"a\u0012\u00032B\u0005\t\u0019AA%\u0011)\t\u0019F!-\u0011\u0002\u0003\u0007\u0011\u0011\n\u0005\u000b\u0003/\u0012\t\f%AA\u0002\u0005%\u0003\"CA.\u0005c\u0003\n\u00111\u0001>\u0011%\tyF!-\u0011\u0002\u0003\u0007Q\bC\u0005\u0003D\u0002\t\n\u0011\"\u0001\u0003F\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\nTC\u0001BdU\u0011\tIE!3,\u0005\t-\u0007\u0003\u0002Bg\u0005/l!Aa4\u000b\t\tE'1[\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!61\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00053\u0014yMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011B!8\u0001#\u0003%\tA!2\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!I!\u0011\u001d\u0001\u0012\u0002\u0013\u0005!QY\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\u0011)\u000fAI\u0001\n\u0003\u00119/\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t%(fA\u001f\u0003J\"I!Q\u001e\u0001\u0012\u0002\u0013\u0005!q]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011%\u0011\t\u0010AA\u0001\n\u0003\u0012\u00190A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005k\u0004B!a \u0003x&!!\u0011UAA\u0011!\u0011Y\u0010AA\u0001\n\u0003a\u0014\u0001\u00049s_\u0012,8\r^!sSRL\b\"\u0003B\u0000\u0001\u0005\u0005I\u0011AB\u0001\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\u0018\u0004\u0004!AQK!@\u0002\u0002\u0003\u0007Q\bC\u0005\u0004\b\u0001\t\t\u0011\"\u0011\u0004\n\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0004\fA11QBB\n\u0005?j!aa\u0004\u000b\u0007\rE\u0001'\u0001\u0006d_2dWm\u0019;j_:LAa!\u0006\u0004\u0010\tA\u0011\n^3sCR|'\u000fC\u0005\u0004\u001a\u0001\t\t\u0011\"\u0001\u0004\u001c\u0005A1-\u00198FcV\fG\u000eF\u0002h\u0007;A\u0011\"VB\f\u0003\u0003\u0005\rAa\u0018\t\u0013\r\u0005\u0002!!A\u0005B\r\r\u0012AB3rk\u0006d7\u000fF\u0002h\u0007KA\u0011\"VB\u0010\u0003\u0003\u0005\rAa\u0018)\u0017\u0001\u0019Ica\f\u00042\rU2q\u0007\t\u0005\u0003\u0017\u001aY#C\u0002\u0004.\u0011\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u00044\u0005)yD\u0003\u0011!A\u0001zf)\u0016(D?\"\u001aw\u000e\u001c\u0017!a\u0016\u00148-\u001a8uC\u001e,\u0007e\u0017\u0017!C\u000e\u001cWO]1dsvK\u0003%\f\u0011SKR,(O\\:!i\",\u0007%\u00199qe>D\u0018.\\1uK\u0002\u0002XM]2f]RLG.\u001a\u0011wC2,X\rI8gA9,X.\u001a:jG*\u0001\u0003\u0005\t\u0011!A\r|G.^7oA\u0001\u001cw\u000e\u001c1!CR\u0004C\u000f[3!O&4XM\u001c\u0011qKJ\u001cWM\u001c;bO\u0016t\u0003\u0005\u00165fAY\fG.^3!_\u001a\u0004\u0003/\u001a:dK:$\u0018mZ3![V\u001cH\u000f\t2fA\t,Go^3f]\u0002\u0002d\u0006\r\u0006!A\u0001\u0002\u0003\u0005I1oI\u0002\nd\u0006\r\u0018!)\",\u0007\u0005Y1dGV\u0014\u0018mY=aAA\f'/Y7fi\u0016\u0014\b\u0005\u000b3fM\u0006,H\u000e\u001e\u001e!cA\u0002\u0004\u0007M\u0015!SN\u0004\u0013\r\t9pg&$\u0018N^3!]VlWM]5dA1LG/\u001a:bY\u0002:\b.[2i\u0015\u0001\u0002\u0003\u0005\t\u0011!G>tGO]8mg\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^5p]\u0002\n7mY;sC\u000eL\b%\u0019;!i\",\u0007eY8ti\u0002zg\rI7f[>\u0014\u0018P\f\u0011IS\u001eDWM\u001d\u0011wC2,X\rI8gA\u0001\f7mY;sC\u000eL\b\rI=jK2$7O\u0003\u0011!A\u0001\u0002\u0003EY3ui\u0016\u0014\b%Y2dkJ\f7-\u001f\u0017!AFr\u0003gL1dGV\u0014\u0018mY=aA%\u001c\b\u0005\u001e5fAI,G.\u0019;jm\u0016\u0004SM\u001d:pe\u0002zg\r\t;iK\u0002\n\u0007\u000f\u001d:pq&l\u0017\r^5p]:R\u0001\u0005\t\u0011!A\u0001:\u0006.\u001a8!AB,'oY3oi\u0006<W\r\u0019\u0011jg\u0002\ng\u000eI1se\u0006LH\u0006I3bG\"\u0004c/\u00197vK\u0002zg\r\t;iK\u0002\u0002XM]2f]R\fw-\u001a\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011cKR<X-\u001a8!a9\u0002\u0004%\u00198eAEr\u0003G\f\u0006!A\u0001\u0002\u0003\u0005I%oAQD\u0017n\u001d\u0011dCN,G\u0006\t:fiV\u0014hn\u001d\u0011uQ\u0016\u0004\u0013\r\u001d9s_bLW.\u0019;fAA,'oY3oi&dW\rI1se\u0006L\be\u001c4!G>dW/\u001c8!A\u000e|G\u000e\u0019\u0011bi\u0002\"\b.\u001a\u0011hSZ,gN\u0003\u0011!A\u0001\u0002\u0003\u0005]3sG\u0016tG/Y4fA\u0005\u0014(/Y=/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\re\u0012!!\u000b\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QE\u0002d\u0006\r\u0017!CJ\u0014\u0018-\u001f\u00151]Ub\u0003\u0005\r\u00185Y\u0001\u0002d&M\u0015-AE\u0002\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7F\u0002d\u0006\r\u00172a9\u0002D&\r\u0019/auS\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006&\r\u0019/a1\u0002\u0003GL\u001b-AE\u0002\u0004'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!cAr\u0003G\u0003\u0011!\u0001")
public class ApproximatePercentile
extends TypedImperativeAggregate<PercentileDigest>
implements ImplicitCastInputTypes,
Serializable {
    private final Expression child;
    private final Expression percentageExpression;
    private final Expression accuracyExpression;
    private final int mutableAggBufferOffset;
    private final int inputAggBufferOffset;
    private int accuracy;
    private Tuple2<Object, double[]> x$1;
    private boolean returnPercentileArray;
    private double[] percentages;
    private volatile byte bitmap$0;

    public static Option<Tuple5<Expression, Expression, Expression, Object, Object>> unapply(ApproximatePercentile approximatePercentile) {
        return ApproximatePercentile$.MODULE$.unapply(approximatePercentile);
    }

    public static PercentileDigestSerializer serializer() {
        return ApproximatePercentile$.MODULE$.serializer();
    }

    public static int DEFAULT_PERCENTILE_ACCURACY() {
        return ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY();
    }

    private int accuracy$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.accuracy = BoxesRunTime.unboxToInt((Object)this.accuracyExpression().eval(this.accuracyExpression().eval$default$1()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.accuracy;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$1$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                Object object = this.percentageExpression().eval(this.percentageExpression().eval$default$1());
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)new double[]{d});
                } else {
                    if (!(object instanceof ArrayData)) throw new MatchError(object);
                    ArrayData arrayData = (ArrayData)object;
                    tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)arrayData.toDoubleArray());
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                boolean returnPercentileArray = tuple23._1$mcZ$sp();
                double[] percentages = (double[])tuple23._2();
                boolean bl = returnPercentileArray;
                if (percentages == null) throw new MatchError((Object)tuple23);
                double[] dArray = percentages;
                this.x$1 = tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)bl), (Object)dArray);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.x$1;
        }
    }

    private boolean returnPercentileArray$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.returnPercentileArray = this.x$1()._1$mcZ$sp();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.returnPercentileArray;
        }
    }

    private double[] percentages$lzycompute() {
        ApproximatePercentile approximatePercentile = this;
        synchronized (approximatePercentile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.percentages = (double[])this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.percentages;
        }
    }

    public Expression child() {
        return this.child;
    }

    public Expression percentageExpression() {
        return this.percentageExpression;
    }

    public Expression accuracyExpression() {
        return this.accuracyExpression;
    }

    @Override
    public int mutableAggBufferOffset() {
        return this.mutableAggBufferOffset;
    }

    @Override
    public int inputAggBufferOffset() {
        return this.inputAggBufferOffset;
    }

    private int accuracy() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.accuracy$lzycompute() : this.accuracy;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{NumericType$.MODULE$, DateType$.MODULE$, TimestampType$.MODULE$})), TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{DoubleType$.MODULE$, ArrayType$.MODULE$.apply(DoubleType$.MODULE$)})), IntegerType$.MODULE$}));
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private boolean returnPercentileArray() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.returnPercentileArray$lzycompute() : this.returnPercentileArray;
    }

    private double[] percentages() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.percentages$lzycompute() : this.percentages;
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult defaultCheck = ExpectsInputTypes$class.checkInputDataTypes(this);
        return defaultCheck.isFailure() ? defaultCheck : (this.percentageExpression().foldable() && this.accuracyExpression().foldable() ? (this.accuracy() <= 0 ? new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy provided must be a positive integer literal (current value = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.accuracy())}))) : (Predef$.MODULE$.doubleArrayOps(this.percentages()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(double percentage) {
                return this.apply$mcZD$sp(percentage);
            }

            public boolean apply$mcZD$sp(double percentage) {
                return percentage < 0.0 || percentage > 1.0;
            }
        }) ? new TypeCheckResult.TypeCheckFailure(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"All percentage values must be between 0.0 and 1.0 "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(current = ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.doubleArrayOps(this.percentages()).mkString(", ")}))).toString()) : TypeCheckResult$TypeCheckSuccess$.MODULE$)) : new TypeCheckResult.TypeCheckFailure(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The accuracy or percentage provided must be a constant literal"})).s((Seq)Nil$.MODULE$)));
    }

    @Override
    public PercentileDigest createAggregationBuffer() {
        double relativeError = 1.0 / (double)this.accuracy();
        return new PercentileDigest(relativeError);
    }

    @Override
    public PercentileDigest update(PercentileDigest buffer, InternalRow inputRow) {
        DataType dataType2;
        block8: {
            block4: {
                double d;
                block6: {
                    Object value2;
                    block7: {
                        block5: {
                            value2 = this.child().eval(inputRow);
                            if (value2 == null) break block4;
                            dataType2 = this.child().dataType();
                            if (!DateType$.MODULE$.equals(dataType2)) break block5;
                            d = BoxesRunTime.unboxToInt((Object)value2);
                            break block6;
                        }
                        if (!TimestampType$.MODULE$.equals(dataType2)) break block7;
                        d = BoxesRunTime.unboxToLong((Object)value2);
                        break block6;
                    }
                    if (!(dataType2 instanceof NumericType)) break block8;
                    NumericType numericType = (NumericType)dataType2;
                    d = numericType.numeric().toDouble(value2);
                }
                double doubleValue = d;
                buffer.add(doubleValue);
            }
            return buffer;
        }
        if (dataType2 != null) {
            DataType dataType3 = dataType2;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType3.catalogString()})));
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public PercentileDigest merge(PercentileDigest buffer, PercentileDigest other) {
        buffer.merge(other);
        return buffer;
    }

    @Override
    public Object eval(PercentileDigest buffer) {
        DataType dataType2;
        block13: {
            Object object;
            block5: {
                double[] doubleResult;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block4: {
                                                doubleResult = buffer.getPercentiles(this.percentages());
                                                dataType2 = this.child().dataType();
                                                if (!DateType$.MODULE$.equals(dataType2)) break block4;
                                                object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final int apply(double x$2) {
                                                        return this.apply$mcID$sp(x$2);
                                                    }

                                                    public int apply$mcID$sp(double x$2) {
                                                        return (int)x$2;
                                                    }
                                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                                                break block5;
                                            }
                                            if (!TimestampType$.MODULE$.equals(dataType2)) break block6;
                                            object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final long apply(double x$3) {
                                                    return this.apply$mcJD$sp(x$3);
                                                }

                                                public long apply$mcJD$sp(double x$3) {
                                                    return (long)x$3;
                                                }
                                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                                            break block5;
                                        }
                                        if (!ByteType$.MODULE$.equals(dataType2)) break block7;
                                        object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final byte apply(double x$4) {
                                                return (byte)x$4;
                                            }
                                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
                                        break block5;
                                    }
                                    if (!ShortType$.MODULE$.equals(dataType2)) break block8;
                                    object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final short apply(double x$5) {
                                            return (short)x$5;
                                        }
                                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Short()));
                                    break block5;
                                }
                                if (!IntegerType$.MODULE$.equals(dataType2)) break block9;
                                object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(double x$6) {
                                        return this.apply$mcID$sp(x$6);
                                    }

                                    public int apply$mcID$sp(double x$6) {
                                        return (int)x$6;
                                    }
                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
                                break block5;
                            }
                            if (!LongType$.MODULE$.equals(dataType2)) break block10;
                            object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final long apply(double x$7) {
                                    return this.apply$mcJD$sp(x$7);
                                }

                                public long apply$mcJD$sp(double x$7) {
                                    return (long)x$7;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                            break block5;
                        }
                        if (!FloatType$.MODULE$.equals(dataType2)) break block11;
                        object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final float apply(double x$8) {
                                return this.apply$mcFD$sp(x$8);
                            }

                            public float apply$mcFD$sp(double x$8) {
                                return (float)x$8;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
                        break block5;
                    }
                    if (!DoubleType$.MODULE$.equals(dataType2)) break block12;
                    object = doubleResult;
                    break block5;
                }
                if (!(dataType2 instanceof DecimalType)) break block13;
                object = Predef$.MODULE$.doubleArrayOps(doubleResult).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Decimal apply(double x$9) {
                        return Decimal$.MODULE$.apply(x$9);
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Decimal.class)));
            }
            Object result = object;
            return ScalaRunTime$.MODULE$.array_length(result) == 0 ? null : (this.returnPercentileArray() ? new GenericArrayData(result) : ScalaRunTime$.MODULE$.array_apply(result, 0));
        }
        if (dataType2 != null) {
            DataType dataType3 = dataType2;
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected data type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{dataType3.catalogString()})));
        }
        throw new MatchError((Object)dataType2);
    }

    @Override
    public ApproximatePercentile withNewMutableAggBufferOffset(int newOffset) {
        int x$10 = newOffset;
        Expression x$11 = this.copy$default$1();
        Expression x$12 = this.copy$default$2();
        Expression x$13 = this.copy$default$3();
        int x$14 = this.copy$default$5();
        return this.copy(x$11, x$12, x$13, x$10, x$14);
    }

    @Override
    public ApproximatePercentile withNewInputAggBufferOffset(int newOffset) {
        int x$15 = newOffset;
        Expression x$16 = this.copy$default$1();
        Expression x$17 = this.copy$default$2();
        Expression x$18 = this.copy$default$3();
        int x$19 = this.copy$default$4();
        return this.copy(x$16, x$17, x$18, x$19, x$15);
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{this.child(), this.percentageExpression(), this.accuracyExpression()}));
    }

    @Override
    public boolean nullable() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.returnPercentileArray() ? new ArrayType(this.child().dataType(), false) : this.child().dataType();
    }

    @Override
    public String prettyName() {
        return "percentile_approx";
    }

    @Override
    public byte[] serialize(PercentileDigest obj) {
        return ApproximatePercentile$.MODULE$.serializer().serialize(obj);
    }

    @Override
    public PercentileDigest deserialize(byte[] bytes) {
        return ApproximatePercentile$.MODULE$.serializer().deserialize(bytes);
    }

    public ApproximatePercentile copy(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        return new ApproximatePercentile(child, percentageExpression, accuracyExpression, mutableAggBufferOffset, inputAggBufferOffset);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    public Expression copy$default$2() {
        return this.percentageExpression();
    }

    public Expression copy$default$3() {
        return this.accuracyExpression();
    }

    public int copy$default$4() {
        return this.mutableAggBufferOffset();
    }

    public int copy$default$5() {
        return this.inputAggBufferOffset();
    }

    @Override
    public String productPrefix() {
        return "ApproximatePercentile";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.inputAggBufferOffset());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.mutableAggBufferOffset());
                break;
            }
            case 2: {
                object = this.accuracyExpression();
                break;
            }
            case 1: {
                object = this.percentageExpression();
                break;
            }
            case 0: {
                object = this.child();
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ApproximatePercentile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ApproximatePercentile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ApproximatePercentile approximatePercentile = (ApproximatePercentile)x$1;
        Expression expression = this.child();
        Expression expression2 = approximatePercentile.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.percentageExpression();
        Expression expression4 = approximatePercentile.percentageExpression();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.accuracyExpression();
        Expression expression6 = approximatePercentile.accuracyExpression();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (this.mutableAggBufferOffset() != approximatePercentile.mutableAggBufferOffset()) return false;
        if (this.inputAggBufferOffset() != approximatePercentile.inputAggBufferOffset()) return false;
        if (!approximatePercentile.canEqual(this)) return false;
        return true;
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression, int mutableAggBufferOffset, int inputAggBufferOffset) {
        this.child = child;
        this.percentageExpression = percentageExpression;
        this.accuracyExpression = accuracyExpression;
        this.mutableAggBufferOffset = mutableAggBufferOffset;
        this.inputAggBufferOffset = inputAggBufferOffset;
        ExpectsInputTypes$class.$init$(this);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression, Expression accuracyExpression) {
        this(child, percentageExpression, accuracyExpression, 0, 0);
    }

    public ApproximatePercentile(Expression child, Expression percentageExpression) {
        this(child, percentageExpression, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)ApproximatePercentile$.MODULE$.DEFAULT_PERCENTILE_ACCURACY())));
    }

    public static class PercentileDigest {
        private QuantileSummaries summaries;

        private QuantileSummaries summaries() {
            return this.summaries;
        }

        private void summaries_$eq(QuantileSummaries x$1) {
            this.summaries = x$1;
        }

        public boolean isCompressed() {
            return this.summaries().compressed();
        }

        public QuantileSummaries quantileSummaries() {
            if (!this.isCompressed()) {
                this.compress();
            }
            return this.summaries();
        }

        public void add(double value2) {
            this.summaries_$eq(this.summaries().insert(value2));
        }

        public void merge(PercentileDigest other) {
            if (!this.isCompressed()) {
                this.compress();
            }
            this.summaries_$eq(this.summaries().merge(other.quantileSummaries()));
        }

        /*
         * WARNING - void declaration
         */
        public double[] getPercentiles(double[] percentages) {
            double[] dArray;
            if (!this.isCompressed()) {
                this.compress();
            }
            if (this.summaries().count() == 0L || percentages.length == 0) {
                dArray = (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
            } else {
                void var2_2;
                double[] result = new double[percentages.length];
                for (int i = 0; i < percentages.length; ++i) {
                    result[i] = BoxesRunTime.unboxToDouble((Object)this.summaries().query(percentages[i]).get());
                }
                dArray = var2_2;
            }
            return dArray;
        }

        private final void compress() {
            this.summaries_$eq(this.summaries().compress());
        }

        public PercentileDigest(QuantileSummaries summaries) {
            this.summaries = summaries;
        }

        public PercentileDigest(double relativeError) {
            int x$20 = QuantileSummaries$.MODULE$.defaultCompressThreshold();
            double x$21 = relativeError;
            boolean x$22 = true;
            QuantileSummaries.Stats[] x$23 = QuantileSummaries$.MODULE$.$lessinit$greater$default$3();
            long x$24 = QuantileSummaries$.MODULE$.$lessinit$greater$default$4();
            this(new QuantileSummaries(x$20, x$21, x$23, x$24, x$22));
        }
    }

    public static class PercentileDigestSerializer {
        private final int length(QuantileSummaries summaries) {
            return 24 + summaries.sampled().length * 24;
        }

        public final byte[] serialize(PercentileDigest obj) {
            QuantileSummaries summary = obj.quantileSummaries();
            ByteBuffer buffer = ByteBuffer.wrap(new byte[this.length(summary)]);
            buffer.putInt(summary.compressThreshold());
            buffer.putDouble(summary.relativeError());
            buffer.putLong(summary.count());
            buffer.putInt(summary.sampled().length);
            for (int i = 0; i < summary.sampled().length; ++i) {
                QuantileSummaries.Stats stat = summary.sampled()[i];
                buffer.putDouble(stat.value());
                buffer.putLong(stat.g());
                buffer.putLong(stat.delta());
            }
            return buffer.array();
        }

        public final PercentileDigest deserialize(byte[] bytes) {
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            int compressThreshold = buffer.getInt();
            double relativeError = buffer.getDouble();
            long count = buffer.getLong();
            int sampledLength = buffer.getInt();
            QuantileSummaries.Stats[] sampled = new QuantileSummaries.Stats[sampledLength];
            for (int i = 0; i < sampledLength; ++i) {
                double value2 = buffer.getDouble();
                long g = buffer.getLong();
                long delta = buffer.getLong();
                sampled[i] = new QuantileSummaries.Stats(value2, g, delta);
            }
            QuantileSummaries summary = new QuantileSummaries(compressThreshold, relativeError, sampled, count, true);
            return new PercentileDigest(summary);
        }
    }
}

