--100 sposobw na SQL, Sposb 87: 
--Wersja oracle

----------------------
--   Przygotowania  --
----------------------

CREATE VIEW pierwszyDzien AS SELECT DATE '2007-03-01' AS pierwszy
FROM dual;
CREATE TABLE kal (d DAtE PRIMARY KEY);

INSERT INTO kal(d)
  SELECT pierwszy + i FROM pierwszyDzien CROSS JOIN sto;
CREATE TABLE swieci
(d DAtE
,imie VARCHAR(20)
);
INSERT INTO swieci VALUES (DATE '2007-03-08', 'Sw. Jan');
INSERT INTO swieci VALUES (DATE '2007-03-09', 'Sw. Franciszek');
INSERT INTO swieci VALUES (DATE '2007-03-17', 'Sw. Patryk');
INSERT INTO swieci VALUES (DATE '2007-03-19', 'Sw. Jozef');
INSERT INTO swieci VALUES (DATE '2007-03-23', 'Sw. Turibiusz');

INSERT INTO swieci VALUES (DATE '2007-05-01', 'Sw. Jozef');
INSERT INTO swieci VALUES (DATE '2007-05-02', 'St. Athanasius');
INSERT INTO swieci VALUES (DATE '2007-05-03', 'Sw. Filip');
INSERT INTO swieci VALUES (DATE '2007-05-12', 'Sw. Pankracy');
---------------------
--       Sposb    --
---------------------



CREATE VIEW poczatekTygodnia AS
  SELECT EXTRACT(DAY FROM d) - TO_CHAR(d,'d')-1 AS wk
   FROM kal JOIN pierwszyDzien
     ON (EXTRACT(MONTH FROM d) = EXTRACT(MONTH FROM pierwszy))
   GROUP BY  EXTRACT(DAY FROM d) - TO_CHAR(d,'d')-1;


CREATE VIEW kalSiatka AS
SELECT wk, pierwszy + CAST(wk AS INT) + 0 AS Nd
         , pierwszy + CAST(wk AS INT) + 1 AS Pon
         , pierwszy + CAST(wk AS INT) + 2 AS Wt
         , pierwszy + CAST(wk AS INT) + 3 AS Sr
         , pierwszy + CAST(wk AS INT) + 4 AS Czw
         , pierwszy + CAST(wk AS INT) + 5 AS Pt
         , pierwszy + CAST(wk AS INT) + 6 AS Sob
  FROM poczatekTygodnia CROSS JOIN pierwszyDzien;


SELECT * FROM kalSiatka;
SELECT
  COALESCE((SELECT imie FROM swieci WHERE d=Nd),
           CAST(EXTRACT(DAY FROM Nd) AS CHAR(2))) AS Nd
 ,COALESCE((SELECT imie FROM swieci WHERE d=Pon),
           CAST(EXTRACT(DAY FROM Pon) AS CHAR(2))) AS Pon
 ,COALESCE((SELECT imie FROM swieci WHERE d=Wt),
           CAST(EXTRACT(DAY FROM Wt) AS CHAR(2))) AS Wt
 ,COALESCE((SELECT imie FROM swieci WHERE d=Sr),
           CAST(EXTRACT(DAY FROM Sr) AS CHAR(2))) AS Sr
 ,COALESCE((SELECT imie FROM swieci WHERE d=Czw),
           CAST(EXTRACT(DAY FROM Czw) AS CHAR(2))) AS Czw
 ,COALESCE((SELECT imie FROM swieci WHERE d=Pt),
           CAST(EXTRACT(DAY FROM Pt) AS CHAR(2))) AS Pt
 ,COALESCE((SELECT imie FROM swieci WHERE d=Sob),
           CAST(EXTRACT(DAY FROM Sob) AS CHAR(2))) AS Sob
FROM kalSiatka
ORDER BY wk;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP VIEW kalSiatka;
DROP VIEW poczatekTygodnia;
DROP VIEW pierwszyDzien;
DROP TABLE kal;
DROP TABLE swieci;
