--100 sposobw na SQL, Sposb 51: Wywietlanie wierszy w charakterze kolumn
--Wersja postgres

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE rezultatyKursu
(student    VARCHAR(20)
,kurs     VARCHAR(20)
,rezultat      INT
);
INSERT INTO rezultatyKursu VALUES ('Jan Kowalski','Java',80);
INSERT INTO rezultatyKursu VALUES ('Jan Kowalski','Bazy_danych',70);
INSERT INTO rezultatyKursu VALUES ('Jan Kowalski','Algebra',50);
INSERT INTO rezultatyKursu VALUES ('Artur Nowak','Java',62);
INSERT INTO rezultatyKursu VALUES ('Artur Nowak','Bazy_danych',95);
INSERT INTO rezultatyKursu VALUES ('Artur Nowak','Algebra',62);
CREATE TABLE Studenci (imie  VARCHAR(20) PRIMARY KEY);
INSERT INTO Studenci(imie) SELECT DISTINCT student FROM rezultatyKursu;
---------------------
--       Sposb    --
---------------------

SELECT imie, java.rezultat AS Java,
             BD.rezultat   AS BD,
             alg.rezultat  AS Algebra
  FROM Studenci
    JOIN rezultatyKursu java ON 
      (imie=java.student AND java.kurs='Java')
    JOIN rezultatyKursu BD   ON 
      (imie=BD.student   AND BD.kurs='Bazy_danych')
    JOIN rezultatyKursu alg  ON
      (imie=alg.student  AND alg.kurs='Algebra');

DELETE FROM rezultatyKursu WHERE student='Jan Kowalski' AND kurs='Algebra';

SELECT imie, java.rezultat AS Java,    BD.rezultat AS BD,
             alg.rezultat  AS Algebra
  FROM Studenci
    LEFT OUTER JOIN rezultatyKursu java ON 
      (imie=java.student AND java.kurs='Java')
    LEFT OUTER JOIN rezultatyKursu BD   ON 
      (imie=BD.student   AND BD.kurs='Bazy_danych')
    LEFT OUTER JOIN rezultatyKursu alg  ON 
      (imie=alg.student  AND alg.kurs='Algebra');


SELECT imie,
  CASE WHEN kurs='Java'       
      THEN rezultat ELSE NULL END   AS Java,
  CASE WHEN kurs='Bazy_danych'   
      THEN rezultat ELSE NULL END   AS  BD,
  CASE WHEN kurs='Algebra'    
      THEN rezultat ELSE NULL END   AS Algebra
FROM Studenci JOIN rezultatyKursu ON (imie=student);

SELECT imie,
  MAX(CASE WHEN kurs='Java'       
      THEN rezultat ELSE NULL END)  AS Java,
  MAX(CASE WHEN kurs='Bazy_danych'   
      THEN rezultat ELSE NULL END)  AS  BD,
  MAX(CASE WHEN kurs='Algebra'    
      THEN rezultat ELSE NULL END)  AS  Algebra
FROM Studenci JOIN rezultatyKursu ON (imie=student)
GROUP BY imie;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE rezultatyKursu;
DROP TABLE Studenci;