--100 sposobw na SQL, Sposb 27: Identyfikowanie nakadajcych si zakresw
--Wersja postgres

----------------------
--   Przygotowania  --
----------------------


CREATE TABLE kandydat
(imie VARCHAR(10) NOT NULL PRIMARY KEY
,min  INTEGER
,maks INTEGER
);
CREATE TABLE praca
(opis VARCHAR(20) NOT NULL PRIMARY KEY
,min   INTEGER
,maks  INTEGER
);

INSERT INTO kandydat VALUES ('Michal'  ,21500,30000);
INSERT INTO kandydat VALUES ('Daniel',10000,17000);
INSERT INTO praca VALUES ('Przedstawiciel handlowy',     20000,22000);
INSERT INTO praca VALUES ('Kierowca',15000,16000);


CREATE TABLE praca
(id         VARCHAR(20)
,pracaPocztek DATE
,pracaKoniec   DATE
);
CREATE TABLE dostepnosc
(pracownik     VARCHAR(20)
,dostPoczatek DATE
,dostKoniec   DATE
);

INSERT INTO praca VALUES ('Alaska', DATE '2007-05-21', DATE '2007-05-27');
INSERT INTO praca VALUES ('Trynidad', DATE '2007-05-01', DATE '2007-05-06');
INSERT INTO dostepnosc VALUES('Michal',  DATE '2007-05-05', DATE '2007-05-09');
INSERT INTO dostepnosc VALUES('Michal',  DATE '2007-05-16', DATE '2007-05-26');
INSERT INTO dostepnosc VALUES('Daniel',DATE '2007-05-19', DATE '2007-05-31');
---------------------
--       Sposb    --
---------------------

SELECT * FROM kandydat wymagania CROSS JOIN  praca oferta
 ORDER BY imie, opis;
SELECT * FROM kandydat wymagania JOIN praca oferta
  ON wymagania.maks < oferta.min OR wymagania.min > oferta.maks
 ORDER BY imie, opis;
SELECT * FROM kandydat wymagania JOIN praca oferta
  ON wymagania.maks >= oferta.min AND wymagania.min <= oferta.maks
 ORDER BY imie, opis;

SELECT pracownik, id,
       GREATEST(pracaPocztek,dostPoczatek) AS dataPoczatek,
       LEAST(pracaKoniec,dostKoniec)        AS dataKoniec,
       1+LEAST(pracaKoniec,dostKoniec)-GREATEST(pracaPocztek,dostPoczatek) 
                                       AS dniPrzepracowane,
       1+pracaKoniec-pracaPocztek           AS dniWymagane
  FROM praca CROSS JOIN dostepnosc
 WHERE LEAST(pracaKoniec,dostKoniec)>=GREATEST(pracaPocztek,dostPoczatek);
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE kandydat;
DROP TABLE praca;
DROP TABLE praca;
DROP TABLE dostepnosc;

