--100 sposobw na SQL, Sposb 96: Tworzenie dziennika zdarze
--Wersja mysql

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE drobneWydatki
(nr   INT
,kiedy   DATE
,kto   VARCHAR(20)
,opis VARCHAR(100)
,kwota DECIMAL(8,2)
);
----------------------
--       Sposb     --
----------------------

CREATE TABLE drobneWydatkiHistoria
(nr         INTEGER
,kiedy         DATE
,kto         VARCHAR(10)
,opis VARCHAR(100)
,kwota      DECIMAL(8,2)
,zmienioneKiedy TIMESTAMP DEFAULT CURRENT_TIMESTAMP
,zmienionePrzez   VARCHAR(50)
);

CREATE TRIGGER dwhIns
  AFTER INSERT ON drobneWydatki
  FOR EACH ROW
    INSERT INTO drobneWydatkiHistoria
      (nr,kiedy,kto,opis,kwota,zmienionePrzez) VALUES
      (new.nr,new.kiedy,new.kto,new.opis,
       new.kwota,current_user);

CREATE TRIGGER dwhUpd
  AFTER UPDATE ON drobneWydatki
  FOR EACH ROW
    INSERT INTO drobneWydatkiHistoria
      (nr,kiedy,kto,opis,kwota,zmienionePrzez) VALUES
      (new.nr,new.kiedy,new.kto,new.opis,
       new.kwota,current_user);

INSERT INTO drobneWydatki (nr,kiedy,kto,opis,kwota) VALUES (1,DATE '2006-06-11','Roman','Zakup owka',0.50);
INSERT INTO drobneWydatki (nr,kiedy,kto,opis,kwota) VALUES (2,DATE '2006-06-12','Roman','Opata za takswk',14.00);

UPDATE drobneWydatki
   SET opis = 'Zdalnie sterowane samochody',
       kwota      = 5000
WHERE nr = 1;

INSERT INTO drobneWydatki (nr,kiedy,kto,opis,kwota) VALUES (3,DATE '2006-06-13','Roman','AA Batteries',5.00);

SELECT * FROM drobneWydatki;
SELECT * FROM drobneWydatkiHistoria;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE drobneWydatki;
DROP TABLE drobneWydatkiHistoria;