--100 sposobw na SQL, Sposb 37: Porwnywanie faktur i wpat
--Wersja oracle

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE faktura
(id      INTEGER PRIMARY KEY
,klient    VARCHAR(20)
,konto INTEGER
,kwota  DECIMAL(10,2)
);


CREATE TABLE bacs
(platnik  INTEGER
,kwota   DECIMAL(10,2)
,numRef VARCHAR(18)
);

INSERT INTO faktura VALUES (1001,'Jan',  8003, 19.99);
INSERT INTO faktura VALUES (1002,'Maria',  4004, 20.99);
INSERT INTO faktura VALUES (1003,'Donald',8105, 11.22);
INSERT INTO faktura VALUES (1004,'Lech',   7003, 10.49);

INSERT INTO bacs VALUES (8003, 19.99, '1001');
INSERT INTO bacs VALUES (4004, 20.99, 'Ref 1002');
INSERT INTO bacs VALUES (1001, 17.22, '8015 1003');
INSERT INTO bacs VALUES (7003, 10.94, 'Lech');
---------------------
--       Sposb    --
---------------------

SELECT * FROM faktura JOIN bacs
  ON faktura.id      = bacs.numRef
 AND faktura.konto = bacs.platnik
 AND faktura.kwota  = bacs.kwota;
DELETE FROM faktura WHERE id=1001;
DELETE FROM bacs WHERE platnik=8003;

SELECT * FROM faktura JOIN bacs
  ON bacs.numRef LIKE CONCAT('%',faktura.id,'%')
 AND faktura.konto = bacs.platnik
 AND faktura.kwota  = bacs.kwota;
DELETE FROM faktura WHERE id=1002;
DELETE FROM bacs WHERE platnik=4004;
SELECT faktura.kwota AS faktura, bacs.kwota AS bacs,
        ABS(faktura.kwota-bacs.kwota) AS diff
  FROM faktura CROSS JOIN bacs;
SELECT faktura.kwota AS faktura, bacs.kwota AS bacs,
        ABS(faktura.kwota-bacs.kwota) AS diff,
        REPLACE(ABS(faktura.kwota-bacs.kwota),'0','')
  FROM faktura CROSS JOIN bacs;

SELECT faktura.kwota AS faktura, bacs.kwota AS bacs,
        ABS(faktura.kwota-bacs.kwota) AS diff
  FROM faktura CROSS JOIN bacs
WHERE REPLACE(REPLACE(ABS(faktura.kwota-bacs.kwota),'0',''),'.','')
         LIKE '_';
SELECT faktura.kwota AS faktura, bacs.kwota AS bacs,
        ABS(faktura.kwota-bacs.kwota) AS diff
  FROM faktura CROSS JOIN bacs
WHERE REPLACE(ABS(faktura.kwota-bacs.kwota),'0','')
         LIKE '__';
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE bacs;
DROP TABLE faktura;
