--100 sposobw na SQL, Sposb 42: Prezentowanie danych z wykorzystaniem skalowalnej grafiki wektorowej
--Wersja mysql

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE d (id    CHAR(40) NOT NULL PRIMARY KEY,
                kolor CHAR(8),
                v     INTEGER);
INSERT INTO d(id, kolor, v) VALUES
  ('Konserwatysci', 'blue',   40),
  ('Partia Demokratyczna',       'red',    30),
  ('Partia Pracy,      'yellow', 20),
  ('Pozostali',        'white',  10);

----------------------
--       Sposb     --
----------------------

CREATE VIEW pie1 AS
       SELECT id, 
              COALESCE((SELECT SUM(v) FROM d WHERE id< x.id),0) AS s,
              (SELECT SUM(v) FROM d WHERE id<=x.id) AS e
         FROM d x;

SELECT * FROM pie1;

CREATE VIEW pie2 AS
       SELECT id, 2*3.1415*s/100 AS s, 2*3.1415*e/100 AS e
         FROM pie1;

SELECT * FROM pie2;


CREATE VIEW pie3 AS
       SELECT id, 100*COS(s) AS x1, 100*SIN(s) AS y1,
                  100*COS(e) AS x2, 100*SIN(e) AS y2
         FROM pie2;

SELECT * FROM pie3;

CREATE VIEW pie4 AS
       SELECT REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
           '<path d="M0 0 l x1 y1 A100,100 0 0, 1 x2,y2 z" fill="kolor"/>'
          ,'x1',x1),'y1',y1),'x2',x2),'y2',y2),'kolor',kolor) AS r
         FROM pie3 JOIN d ON pie3.id=d.id;

SELECT * FROM pie4\G

CREATE VIEW pie5 AS
       SELECT REPLACE(REPLACE(REPLACE(
               '<text x="xx" y="yy">tt</text>'
              ,'xx', (x1+x2)/SQRT((x1+x2)*(x1+x2)+(y1+y2)*(y1+y2))*60)
              ,'yy', (y1+y2)/SQRT((x1+x2)*(x1+x2)+(y1+y2)*(y1+y2))*60)
              ,'tt',id) AS r
         FROM pie3;

SELECT * FROM pie5;

CREATE VIEW pie6 AS
      SELECT 1 AS s,
       '<svg xmlns="http://www.w3.org/2000/svg" stroke="black"' AS r
      UNION
      SELECT 2,
       'viewBox="-120 -120 240 240" text-anchor="middle">'
      UNION
      SELECT 3, r FROM pie4
      UNION
      SELECT 4, r FROM pie5
      UNION
      SELECT 5, '</svg>';

SELECT * FROM pie6;

CREATE VIEW pie7 AS
   SELECT 'text'    AS tag,  id        AS content,
          (x1+x2)/2 AS att1, (y1+y2)/2 AS att2,
          2 AS s
     FROM pie3
  UNION
   SELECT 'path'    AS tag,  ''        AS content,
          REPLACE(REPLACE(REPLACE(REPLACE(
            'M0 0 l x1 y1 A100,100 0 0, 1 x2,y2 z'
            ,'x1',x1),'y1',y1),'x2',x2),'y2',y2) AS att1,
          kolor                                  AS att2,
          1 AS s
     FROM pie3 JOIN d ON pie3.id=d.id;

SELECT * FROM pie7;

--------------------------
--    Usuwanie danych   --
--------------------------
DROP VIEW pie1;
DROP VIEW pie2;
DROP VIEW pie3;
DROP VIEW pie4;
DROP VIEW pie5;
DROP VIEW pie6;
DROP VIEW pie7;
drop table d;