--100 sposobw na SQL, Sposb 03: Warunkowe polecenia Insert
--Wersja sqlserver

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE biblioteka
(czytelnik CHAR(5)
,ksiazka CHAR(5)
 ,wypozyczone_do DATETIME
);
INSERT INTO biblioteka VALUES ('jim01','bk002','2005-03-22');
INSERT INTO biblioteka VALUES ('jim01','bk002','2005-09-21');
INSERT INTO biblioteka VALUES ('ann02','bk005','2005-09-21');
INSERT INTO biblioteka(czytelnik,ksiazka,wypozyczone_do)
  VALUES ('jim01','bk002',
           GetDate()+14
         );
INSERT INTO biblioteka(czytelnik,ksiazka,wypozyczone_do)
  VALUES ('ann02','bk005',
           GetDate()-1
         );
CREATE TABLE zwroty
(ksiazka  CHAR(5)
,czytelnik CHAR(5)
,data_zwrotu DATETIME
,kara       DECIMAL(10,2)
);

CREATE TABLE rezerwacje
(kto   VARCHAR(20)
,co   VARCHAR(20) NOT NULL
,kiedy  DATETIME
            NOT NULL
,PRIMARY KEY (kiedy,co)
);
---------------------
--       Sposb    --
---------------------

INSERT INTO zwroty(ksiazka,czytelnik,data_zwrotu,kara)
  SELECT 'jim01','bk002',GetDate(),
          (SELECT 0.20
             FROM biblioteka
           WHERE czytelnik='jim01' AND ksiazka='bk002'
           HAVING MAX(wypozyczone_do)<GetDate());
INSERT INTO zwroty(ksiazka,czytelnik,data_zwrotu,kara)
  SELECT 'ann02','bk005',GetDate(),
          (SELECT 0.20
             FROM biblioteka
           WHERE czytelnik='ann02' AND ksiazka='bk005'
           HAVING MAX(wypozyczone_do)<GetDate());
SELECT * FROM zwroty;

INSERT INTO rezerwacje VALUES ('Col. Mustard','Sala balowa','2006-07-13');

INSERT INTO rezerwacje(kiedy,co,kto)
  SELECT '2006-07-13','Sala bilardowa','Prof. Plum'
    WHERE NOT EXISTS (SELECT kto FROM rezerwacje
                       WHERE kiedy = '2006-07-13'
                         AND co='Sala bilardowa');

INSERT INTO rezerwacje(kiedy,co,kto)
  SELECT '2006-07-13','Sala balowa','Miss. Scarlet'
    WHERE NOT EXISTS (SELECT kto FROM rezerwacje
                       WHERE kiedy = '2006-07-13'
                         AND co='Sala balowa');

SELECT * FROM rezerwacje;
---------------------------
--    Usuwanie danych    --
---------------------------

DROP TABLE biblioteka;
DROP TABLE zwroty;
DROP TABLE rezerwacje;
