--100 sposobw na SQL, Sposb 03: Warunkowe polecenia Insert
--Wersja mysql

----------------------
--   Przygotowania  --
----------------------

CREATE TABLE biblioteka
(czytelnik CHAR(5)
,ksiazka CHAR(5)
,wypozyczone_do DATE 
);
INSERT INTO biblioteka VALUES ('jim01','bk002',DATE '2005-03-22');
INSERT INTO biblioteka VALUES ('jim01','bk002',DATE '2005-09-21');
INSERT INTO biblioteka VALUES ('ann02','bk005',DATE '2005-09-21');
INSERT INTO biblioteka(czytelnik,ksiazka,wypozyczone_do)
  VALUES ('jim01','bk002',
          CURRENT_DATE + INTERVAL '14' DAY 
         );
INSERT INTO biblioteka(czytelnik,ksiazka,wypozyczone_do)
  VALUES ('ann02','bk005',
          CURRENT_DATE - INTERVAL '1' DAY 
         );
CREATE TABLE zwroty
(ksiazka  CHAR(5)
,czytelnik CHAR(5)
,data_zwrotu DATE
,kara       DECIMAL(10,2)
);

CREATE TABLE Rezerwacje
(kto   VARCHAR(20)
,co   VARCHAR(20) NOT NULL
,kiedy   DATE
            NOT NULL
,PRIMARY KEY (kiedy,co)
);
----------------------
--       Sposb     --
----------------------

INSERT INTO zwroty(czytelnik,ksiazka,data_zwrotu,kara)
  VALUES ('jim01','bk002',CURRENT_DATE,
          (SELECT 5
             FROM biblioteka
           WHERE czytelnik='jim01' AND ksiazka='bk002'
           HAVING MAX(wypozyczone_do)<CURRENT_DATE));
INSERT INTO zwroty(czytelnik,ksiazka,data_zwrotu,kara)
  VALUES ('ann02','bk005',CURRENT_DATE,
          (SELECT 5
             FROM biblioteka
           WHERE czytelnik='ann02' AND ksiazka='bk005'
           HAVING MAX(wypozyczone_do)<CURRENT_DATE));
SELECT * FROM zwroty;

INSERT INTO Rezerwacje VALUES ('Col. Mustard','Sala balowa',DATE '2006-07-13');

INSERT INTO Rezerwacje(kiedy,co,kto)
  SELECT DATE '2006-07-13','Sala bilardowa','Prof. Plum'
    FROM dual
    WHERE NOT EXISTS (SELECT kto FROM Rezerwacje
                       WHERE kiedy = DATE '2006-07-13'
                         AND co='Sala bilardowa');

INSERT INTO Rezerwacje(kiedy,co,kto)
  SELECT DATE '2006-07-13','Sala balowa','Miss. Scarlet'
    FROM dual
    WHERE NOT EXISTS (SELECT kto FROM Rezerwacje
                       WHERE kiedy = DATE '2006-07-13'
                         AND co='Sala balowa');

SELECT * FROM Rezerwacje;
--------------------------
--    Usuwanie danych   --
--------------------------

DROP TABLE biblioteka;
DROP TABLE zwroty;
DROP TABLE Rezerwacje;
