' Dennis Abbott - speckled_trout@hotmail.com
' W komputerze, z ktrego uruchamiamy skrypt, naley najpierw
' zarejestrowa w katalogu System32 obiekt COM System Scripting Runtime.
'
' Potrzebne jest take narzdzie psservice.exe z witryny www.sysinternals.com
' naley je skopiowa do tego samego katalogu, co skrypt. Trzeba take
' utworzy plik tekstowy zawierajcy informacje o podsieciach.
' Poszczeglne podsieci musz by rozdzielone znakiem konca wiersza.
'
' przykad listingu podsieci
'
' 192.168.0.0
' 192.168.1.0
' 34.54.78.0
'
' Dziaanie skryptu mona zaobserwowa poprzez otwarcie pliku dziennika
' za pomoc przegldarki dziennikw, np. SMS Trace firmy Microsoft.
'
'On Error Resume Next
Option Explicit
Dim Title                  'tytu okien dialogowych, a take nazwa pliku dziennika
Dim PathToScript  'cieka do katalogu, w ktrym dziaa skrypt
Dim PathToLogFile  'pena cieka wcznie z nazw pliku dziennika
Dim WshShell  'obiekt powoki
Dim WshNet                  'obiekt sieci
Dim WshFso  'obiekt systemu plikw
Dim WshSysEnv                  'obiekt zawierajcy zmienne rodowiskowe
Dim ScriptNet                  'Obiekt System Scripting Runtime z witryny www.netal.com
Dim ComSpec          'cieka do programu cmd.exe
Dim DataFile  'plik z nazwami komputerw
Dim LogFile          'plik dziennika z informacjami o stanie
Dim CompName          'nazwa biecego zdalnego komputera
Dim User                  'uytkownik zalogowany w zdalnym komputerze
Dim Domain  'domena, do ktrej jest doczony zdalny komputer
Dim IP  'Adres IP zdalnego komputera
Dim CurLine  'zmienna wykorzystywana do przetwarzania plikw tekstowych
Dim NbtFile  'plik przetwarzany w celu wyszukania informacji NetBIOS
Dim SubnetFileName          'plik z informacjami o podsieciach
Dim I          'licznik
Dim SysFolder  'folder systemowy
Dim TimeOut  'limit czasu wykonania polecenia ping (w milisekundach)
Dim Go          'zmienna umoliwiajca zatrzymanie dziaania skryptu
Dim ServiceToCheck 'nazwa wyszukiwanej usugi--TO NIE JEST NAZWA WYWIETLANA
Dim EditSubnets  'zmienna opisujca moliwo edycji pliku podsieci
Dim File  'Obiekt plikowy
Dim Subnet  'przeszukiwana podsie
Dim Service  'Stan usugi
Dim ServFile  'plik, w ktrym s wyszukiwane informacje o usudze

Set WshShell = CreateObject("WScript.Shell")
Set WshFso = CreateObject("Scripting.FileSystemObject")
Set WshNet = CreateObject("WScript.Network")
Set ScriptNet = CreateObject("SScripting.IPNetwork")

SysFolder = WshFso.GetSpecialFolder(1)
PathToScript = Left(WScript.ScriptFullName,(Len(WScript.ScriptFullName) - (Len(WScript.ScriptName) + 1)))
Title = "FindNTService"
Set WshSysEnv = WshShell.Environment("SYSTEM")
ComSpec = WshSysEnv("COMSPEC")
Timeout = 125

'pobranie danych wejciowych
Go = MsgBox("Program przeszukuje sie wedug podsieci " &_
 "w poszukiwaniu komputerw, w ktrych dziaa usuga." & vbcrlf & _
 "Aby program mg dziaa, naley utworzy plik tekstowy z informacjami o podsieciach" & _
 "oraz poda nazw usugi." & vbcrlf & vbcrlf & "Czy chcesz kontynuowa?",vbyesno,Title)
Select Case Go
        Case VbYes
        Case VbNo Wscript.Quit(0)
End Select
If WshFso.FileExists(PathToScript & "\psservice.exe") <> True Then
        MsgBox "Nie zainstalowano programu PSSERVICE..." & vbcrlf & _
        "Program PSSERVICE mona pobra ze strony www.sysinternals.com",vbok + vbcritical, Title
        Wscript.Quit(0)
End If
If WshFso.FileExists(SysFolder & "\sscrrun.dll") <> True Then
        MsgBox "Brak pliku sscrrun.dll..." & vbcrlf & "Mona go pobra ze strony www.netal.com",vbok + vbcritical, Title
        Wscript.Quit(0)
End If
ServiceToCheck = InputBox("Wprowad nazw usugi (nie nazw wywietlan), ktrej " & _
  "chcesz wyszukiwa.",Title,"w3svc")
If ServiceToCheck = "" Then
        MsgBox "Nie wprowadzono nazwy usugi...",vbok + vbcritical, Title
        Wscript.Quit(0)
End If
SubnetFileName = InputBox("Wprowad ciek do nazwy pliku zawierajcego " & _
"informacje o podsieciach.",Title,PathToScript & "\subnets.txt")
If WshFso.FileExists(SubnetFileName) <> True Then
 MsgBox "Plik z informacjami o podsieciach nie istnieje...", _
 vbok + vbcritical, Title
        Wscript.Quit(0)
End If
EditSubnets = MsgBox("Czy chcesz zmodyfikowa plik z informacjami o podsieciach?",vbyesno,Title)
Select Case EditSubnets
        Case vbyes WshShell.Run "notepad " & SubnetFileName,1,True
        Case vbno
End Select

PathToLogFile = PathToScript & "\" & Title & "_" & Month(Now) & "_" &  Day(Now) & "_" & Year(Now) & "-" & Hour(Now) & "_" & Minute(Now) & ".log"
Set LogFile = WshFso.CreateTextFile(PathToLogFile)
Set File = WshFso.GetFile(SubnetFileName)
Set DataFile = File.OpenAsTextStream(1,0)
LogFile.WriteLine "Adres IP" & vbtab & "Nazwa komputera" & vbtab & _
"Nazwa logowania" & vbtab & "Domena" & vbtab & "Status"
Do  While Not DataFile.AtEndOfStream
        Subnet = DataFile.ReadLine
        LogFile.WriteLine subnet & vbtab & vbtab & vbtab & vbtab & _
          "rozpoczto analiz podsieci " & Now
        Discover(subnet)

Loop
MsgBox "Skrypt" & Title & " zakoczy dziaanie.  Plik dziennika zapisano w:" & _
vbcrlf & PathToLogFile

Function Discover(boundary)
        Subnet = Left(boundary,InstrRev(boundary,"."))
        For i = 1 to 254
                IP = subnet & i
                CompName = Null
                User = Null
                Domain = Null
                Curline = Null
                Service = Null
                If ScriptNet.Ping(ip,,,Timeout) <> 0 Then
                        LogFile.WriteLine IP & vbtab & vbtab & vbtab & vbtab _
          & "UnPingableClient"
                Else
                        CompName = ScriptNet.DNSlookup(IP)
                        If InStr(CompName,".") <> 0 Then
                                CompName = Left(CompName,InStr(CompName,".")-1)
                        End If
                        Call GetNBTstat(IP,User,Domain)
                               Call GetService(IP, Service)
                        Call WriteToLog(IP,CompName,User,Domain,Service)
                End If
        Next
End Function

Function GetNBTstat(IP,User,Domain)        
        WshShell.Run ComSpec & " /c nbtstat -a " & IP & " >" & PathToScript & _
 "\nbt.txt",6,True 
        Set NbtFile = WshFso.OpenTextFile(PathToScript & "\nbt.txt", 1, True)
        Do While NbtFile.AtEndOfStream <> True
                CurLine = NbtFile.ReadLine
                If InStr(CurLine,"---") <> 0 Then
                        CurLine = NbtFile.ReadLine
                        CompName = Trim(Left(CurLine,InStr(CurLine,"<")-1))
                End If
                If InStr(CurLine,"<03>") <> 0 Then
                    If Trim(Left(CurLine,InStr(CurLine,"<03>")-1)) <> _
          UCase(CompName) and Trim(Left(CurLine,InStr(CurLine,"<03>")-1)) <> _
          UCase(CompName) & "$" Then
                                User = Trim(Left(CurLine,InStr(CurLine,"<03>")-1))
                        End If
                End If
                If InStr(CurLine,"<1E>") <> 0 Then
                        If Trim(Left(CurLine,InStr(CurLine,"<1E>")-1)) <> _
          UCase(CompName) and Trim(Left(CurLine,InStr(CurLine,"<1E>")-1)) <> _ 
          UCase(CompName) & "$" Then
                                Domain = Trim(Left(CurLine,InStr(CurLine,"<1E>")-1))
                        End If
                End If
        Loop
        NbtFile.Close
End Function

Function GetService(IP,Service)
        If CompName <> "" and User <> "" or Domain <> "" Then
                WshShell.Run ComSpec & " /c " & PathToScript & "\psservice  \\" _
      & IP & " query " & Chr(34) & ServiceToCheck & Chr(34) & " >" _
      & PathToScript & "\service.txt",6,True
                Set ServFile = WshFso.OpenTextFile(PathToScript _
      & "\service.txt", 1, True)
                Do While ServFile.AtEndOfStream <> True
                        CurLine = ServFile.ReadLine
                        If InStr(CurLine,"STATE") <> 0 Then
                                Service = Trim(Right(CurLine,InStr(CurLine," ")-1))
                        End If
                        If InStr(CurLine,"RPC") <> 0 Then
                                Service = CurLine
                        End If
                        If InStr(CurLine,"Access") <> 0 Then
                                Service = CurLine
                        End If
                        If InStr(CurLine,"function") <> 0 Then
                                Service = CurLine
                        End If
                        If InStr(CurLine,"Unable") <> 0 Then
                                Service = CurLine
                        End If
                Loop
                If InStr(Service,vbcr) <> 0 Then
                        Service = Left(Service,InStr(Service,vbcr)-1)
                End If
        End If
End Function

Function WriteToLog(IP,CompName,User,Domain,Service)
        If IP <> "" Then
                LogFile.Write IP
        End If
        LogFile.Write vbtab
        If CompName <> "" Then
                LogFile.Write CompName
        End If
        LogFile.Write vbtab
        If User <> "" Then
                LogFile.Write User
        End If
        LogFile.Write vbtab
        If Domain <> "" Then
                LogFile.Write Domain
        End If
        LogFile.Write vbtab
        If Service <> "" Then
                LogFile.Write Service
        End If
        LogFile.WriteLine
End Function
