'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Plik          :     Logon.vbs
' Zaktualizowano:  Kwiecie 2003
' Wersja        :  2.1
' Autor         :  Dan Thomson, felietonista myITforum.com
'                  e-mail: dethomson@hotmail.com
'
' Zastosowanie:
'           Ten skrypt mona bezporednio wykorzysta jako skrypt logowania
'           dla klientw z systemem Windows 2000 lub wersjami nowszymi. W przypadku starszych 
'           systemw, skrypt mona wywoa z pliku wsadowego .bat.
'
' Parametry wejciowe:
'
' Wymagania:
'       Komputery z systemem Win 9x, ME lub NT 4:
'           - Pakiet Active Directory Client Extensions
'             http://www.microsoft.com/windows2000/techinfo/howitworks/
'             activedirectory/adsilinks.asp
'           - Windows Script
'             http://msdn.microsoft.com/library/default.asp?url=/downloads
'             /list/webdev.asp
'           - Najnowsza wersja przegldarki Internet Explorer
'
' Uwagi:
'           Skrypt testowano w komputerze z systemem Windows 2000 Professional nalecym 
'           do domeny Active Directory
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

On Error Resume Next

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Define Variables and Constants
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

Dim objFileSys
Dim objIntExplorer
Dim objWshNetwork
Dim objWshShell
Dim strDomain           'Domena uytkownika
Dim strHomePage         'Strona macierzysta uytkownika
Dim strLogonPath        'Path to location from where the script is running
Dim strOSProdType       'Typ systemu operacyjnego (WinNT, LanmanNT, ServerNT)
Dim strWorkstation      'Lokalna nazwa komputera
Dim strUserGroups       'Lista grup, do ktrych naley uytkownik
Dim intCounter          'Licznik oglnego przeznaczenia

Const UseNTServer = 0   'Zmienna okrela, czy skrypt ma si uruchomi przy lokalnym logowaniu
                        'na serwerach Windows.
                        'Dopuszczalne wartoci to: 1 (Tak) oraz 0 (Nie)

'Zainicjowanie globalnych obiektw skryptu
Set objFileSys    = CreateObject( "Scripting.FileSystemObject" )
Set objWshNetwork = CreateObject( "WScript.Network" )
Set objWshShell   = CreateObject( "WScript.Shell" )

'Zatrzymanie skryptu do czasu zakoczenia logowania (dotyczy tylko systemw Win 9x lub ME)
'Po 10 sekundach skrypt wznawia dziaanie
strUser = ""
intCounter = 0
Do
  strUserID = objWshNetwork.Username
  intCounter = intCounter + 1
  Wscript.Sleep 500
Loop Until strUserID <> "" OR intCounter > 20

'Sprawdzenie, czy poprawnie wprowadzono nazw uytkownika
If strUserID = "" Then
  objWshShell.Popup "Bd skryptu logowania - skontaktuj si z administratorem", , _
    "Skrypt logowania", 48
  Call Cleanup
End If

'Konfiguracja przegldarki IE do wykorzystania jako okno komunikatw
Call SetupIE

'Wywietlenie komunikatu powitalnego
Call UserPrompt ("Witaj " & strUserID)

'Wprowadzenie poziomej linii 'rozdzielajcej'
objIntExplorer.Document.WriteLn("<hr style=""width:100%""></hr>")

'Pobranie podstawowych informacji o systemie
Call GetSystemInfo

If IsTerminalServerSession <> True Then
  'Wyjcie w przypadku logowania lokalnego na serwerze, jeli wprowadzono takie ustawienia
 IF UseNTServer = 0 AND (strOSProdType = "LanmanNT" OR strOSProdType = "ServerNT") Then
    objWshShell.Popup "Windows Server - zakoczenie dziaania skryptu logowania!", 10, _
    "Logowanie do " & strDomain, 16
    Call CleanUp
  End if
End If

'Pobranie informacji o przynalenoci do grupy
strUserGroups = ""
Call GetLocalGroupMembership
Call GetGlobalGroupMembership

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Mapowanie dyskw, dodawanie udostnionych drukarek i ustawienie domylnej strony
'
' Cz A
' Ta cz skryptu wykonuje dziaania na podstawie nazwy komputera
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'Lewa cz nazwy komputera zawiera informacje o budynku i numerze pokoju
If Instr( 1, strWorkstation, "-", 1) > 0 Then
  strWorkstation = _
    Left( strWorkstation, ( Instr( 1, strWorkstation, "-", 1)))
End If

Select Case UCase( strWorkstation )

  Case "BUD1POK101-"
    Call MapDrive ("U:", "MojSrw1", "MojUdzial1")
    Call AddPrinter ("MojaDomena2", "MojSrwDruk2", "Bud1Pok101-HP4050")
    objWshNetwork.SetDefaultPrinter "\\MojSrwDruk\Bud1Pok101-HP4050"
    strHomePage = "http://www.chesapeake.edu/academic_info/acad_computing.asp"
  Case "BUD1POK202-"
    Call MapDrive ("U:", "MojSrw2", "MojUdzial2")
    Call AddPrinter ("MojaDomena1", "MojSrwDruk1", "Bud1Pok202-HP4000")
    objWshNetwork.SetDefaultPrinter "\\MojSrwDruk1\Bud1Pok202-HP4000"
    strHomePage = "http://www.chesapeake.edu/library/default.asp"
  Case "BUD3POK104-"
    'W tym pokoju wykorzystywane jest drukowanie TCP/IP zamiast serwera drukowania.
    'Ustawienie strony macierzystej
    set homepage strHomePage = "http://www.chesapeake.edu/writing/wchome.htm"
  Case Else

End Select

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Cz B
' W tej czci skryptu s wykonywane operacje na podstawie przynalenoci do grupy
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

If InGroup( "UdzialPersonelu" ) Then
  Call MapDrive ("X:", "SrwPersonelu1", "UdzialPersonelu1")
  strHomePage = "http://www.chesapeake.edu/generalinfo/cambridge.asp"
End If

If InGroup( "UdzialStudentow" ) Then
  Call MapDrive ("Y:", "SrwStudentow1", "UdzialStudentow1")
  strHomePage = "http://www.chesapeake.edu"
End If

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Koniec czci
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

'Ustawienie domylnej strony macierzystej
If strHomePage <> "" Then
  Err.Clear
  objWshShell.RegWrite _
    "HKCU\Software\Microsoft\Internet Explorer\Main\Start Page", strHomePage
  If Err = 0 Then Call UserPrompt ("Set Internet home page to " & strHomePage)
End If

'Uruchomienie skryptu SMSls.bat
'Skryptu nie powinni uruchamia czonkowie grupy Administratorzy domeny
'oraz globalnej grupy NieInstalowacSMS
If InGroup("Administratorzy domeny") OR InGroup("NieInstalowacSMS") Then
  Call UserPrompt ("Pominicie skryptu SMSLS.BAT")
Else
  objWshShell.Run "%COMSPEC% /c " & strLogonPath & "\smsls.bat", 0, False
End If

'Wprowadzenie poziomej linii rozdzielajcej
objIntExplorer.Document.WriteLn("<hr style=""width:100%""></hr>")

'Poinformowanie uytkownika o zakoczeniu procesu logowania
Call UserPrompt ("Zakoczono proces logowania do sieci")

'Pauza 10 sekund
Wscript.Sleep (10000)

'Zamknicie przegldarki Internet Explorer
objIntExplorer.Quit()

Call Cleanup

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:  AddPrinter
'
' Dziaanie:  Podczenie udostpnionej drukarki sieciowej
'
' Parametry wejciowe:
'           strPrtServerDomain  Domena, do ktrej nalezy serwer drukowania
'           strPrtServer        Nazwa serwera drukowania
'           strPrtShare         Nazwa udziau drukowania
'
' Wynik:
'
' Zastosowanie:
'           Call AddPrinter ("MojaDomena2", "MojSrw2", "Bud1Pok101-HP4050")
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub AddPrinter(strPrtServerDomain, strPrtServer, strPrtShare)

  On Error Resume Next

  Dim strPrtPath    'Pena cieka do udziau drukowania
  Dim objPrinter    'Odwoanie do obiektu drukowania
  Dim strMsg        'Komunikat wywietlany do uytkownika
  Dim blnError      'Bd Prawda/Fasz

  blnError = False

  'Wyznaczenie cieki do udziau drukowania
  strPrtPath = "\\" & strPrtServer & "\" & strPrtShare

  'Sprawdzenie, czy udostpniona drukarka istnieje.
  'Kontynuacja, jeli tak, wywietlenie komunikatu o bdzie jeli nie
   Set objPrinter = GetObject _
    ("WinNT://" & strPrtServerDomain & "/" & strPrtServer & "/" & strPrtShare)
  If IsObject( objPrinter ) AND _
  (objPrinter.Name <> "" AND objPrinter.Class = "PrintQueue") Then

     'Rne techniki mapowania w zalenoci od wersji systemu operacyjnego     
    If objWshShell.ExpandEnvironmentStrings( "%OS%" ) = "Windows_NT" Then
       Err.Clear
       'Mapowanie drukarek
       objWshNetwork.AddWindowsPrinterConnection strPrtPath
     Else
       'Mapowanie drukarek w przypadku systemw Win9x i ME sprawia problemy i jest zawodne.
     End If

  Else
    blnError = True
  End IF

  'Sprawdzenie, czy wystpi bd i wywietlenie odpowiedniego komunikatu do uytkownika
  If Err <> 0 OR blnError = True Then
    strMsg = "Nie mona poczy si z drukarka sieciow. " & vbCrLf & _
             "Prosz skontaktowa si z administratorem " & vbCrLf & _
             "i poprosi o sprawdzenie serwera " & strPrtServer & "." & _
             vbCrLf & vbCrLf & _
             "Prosz powiedzie, e nie mona si poczy z drukark '" _ & strPrtShare & "'"
    objWshShell.Popup strMsg,, "Bd logowania !", 48
  Else
    Call UserPrompt ("Pomylnie dodano poczenie z drukark " & strPrtPath)
  End If

  Set objPrinter = Nothing

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:  MapDrive
'
' Dziaanie:  Mapowanie napdu w udostepnionym folderze
'
' Parametry wejciowe:
'           strDrive    Litera dysku, do ktrego zmapowano udzia
'           strServer   Nazwa serwera zawierajcego udzia
'           strShare    Nazwa udziau
'
' Wyniki:
'
' Zastosowanie:
'           Call MapDrive ("X:", "SrwPersonelu1", "UdzialPersonelu1")
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub MapDrive( strDrive, strServer, strShare )

  On Error Resume Next

  Dim strPath       'cieka do udziau drukowania
  Dim blnError    'Wskanik bdu  True (False) 

  blnError = False

    'Rozczenie dysku, jeli liter dysku zmapowano wczeniej.
    'W ten sposb zyskujemy pewno, e wszyscy wykorzystuj takie same mapowanie

  If objFileSys.DriveExists(strDrive) = True Then
    objWshNetwork.RemoveNetworkDrive strDrive, , True
  End If

  'Utworzenie cieki do udziau
  strPath = "\\" & strServer & "\" & strShare

  'Sprawdzenie, czy udzia istnieje. Jeli tak - kontymuacja, jeli nie ustawienie
  'znacznika bdu.
  If objFileSys.DriveExists(strPath) = True Then
    Err.Clear
    objWshNetwork.MapNetworkDrive strDrive, strPath
  Else
    blnError = True
  End If

  'Sprawdzenie, czy wystpi bd i wyswietlenie odpowiedniego komunikatu
  If Err.Number <> 0 OR blnError = True Then
    'Wywietlenie komunikatu z informacj o tym, e poczenie si nie powiodo
    strMsg = "Nie mona poczy si z udziaem sieciowym. " & vbCrLf & _
             "Prosz skontaktowa si z administratorem " & _
             "i poprosi o sprawdzenie serwera " & strServer & "." & vbCrLf & _
             "Prosz powiedzie, e nie mona poaczy si z udziaem " & _ "'" & strPath & "'"
    objWshShell.Popup strMsg,, "Bad logowania!", 48
  Else
    Call UserPrompt ("Pomylnie zmapowano dysk sieciowy dla folderu " & strPath)
  End If
End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura: GetLocalGroupMembership
'
' Dziaanie: Pobranie informacji o przynalenoci uytkownika do grup lokalnych
'
' Parametry wejciowe:
'
' Wyniki:          Nazwy grup lokalnych dodane do zmiennej strUserGroups
'
' Zastosowanie:    Call GetLocalGroupMembership
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub GetLocalGroupMembership

  On Error Resume Next

  Dim colGroups   'Kolekcja grup w komputerze lokalnym
  Dim objGroup    'Adres obiektu dla poszczeglnych grup
  Dim objUser     'Adres obiektu do poszczeglnych czonkw grup 

  'Sprawdzenie, czy w komputerze nie dziaa system Windows 9x lub ME
  If objWshShell.ExpandEnvironmentStrings( "%OS%" ) = "Windows_NT" Then
    'Podczenie do komputera lokalnego
    Set colGroups = GetObject( "WinNT://" & strWorkstation )
    colGroups.Filter = Array( "group" )
    'Przetwarzanie poszczeglnych grup
    For Each objGroup In colGroups
      'Przetwarzanie uytkownikw w grupach
      For Each objUser in objGroup.Members
        'Sprawdzenie, czy uytkownik naley do okrelonej grupy
        If LCase( objUser.Name ) = LCase( strUserID ) Then
         'Dodanie nazw grup do listy
          strUserGroups = strUserGroups & objGroup.Name & ","
        End If
      Next
    Next
    Set colGroups = Nothing
  End If

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:      GetGlobalGroupMembership
'
' Dziaanie:      Pobranie globalnych grup, do ktrych naley uytkownik
'
' Parametry wejciowe:
'
' Wynik:   Nazwy globalnych grup s umieszczone w zmiennej strUserGroups
'
' Zastosowanie:    Call GetGlobalGroupMembership
'
' Uwagi:    W celu zachowania wstecznej zgodnoci z domenami NT 4
'           naley korzysta z poczenia WinNT
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub GetGlobalGroupMembership

  On Error Resume Next

  Dim objNameSpace
  Dim objUser

  Const ADS_READONLY_SERVER = 4

  Set objNameSpace = GetObject( "WinNT:" )
  'Zastosowanie metody OpenDSObject z parametrem ADS_READONLY_SERVER
  'w celu pobrania "najbliszego" kontrolera domeny

  'Podczenie do obiektu uytkownika w domenie
  Set objUser = objNameSpace.OpenDSObject( _
    "WinNT://" & strDomain & "/" & strUserID, "", "", ADS_READONLY_SERVER)
    'Przetwarzanie poszczeglnych grup
  For Each objGroup In objUser.Groups
    'Dodanie nazwy grupy do listy
    strUserGroups = strUserGroups & objGroup.Name & ","
  Next
  Set objNameSpace = Nothing

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Funkcja  : InGroup
'
' Dziaanie: Sprawdzenie, czy uytkownik naley do okrelonej grupy
'
' Parametr wejciowy:    Nazwa grupy, do ktrej sprawdzamy przynaleno
'
' Wynik:     True lub False
'
' Zastosowanie:    If InGroup("Administratorzy domeny") Then <dziaania>
'
' Wymagania:
'           Zmienn strUserGroups nalezy wczeniej wypeni za pomoc
'           procedury GetLocalGroupMembership lub GetGlobalGroupMembership
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function InGroup(strGroup)

  On Error Resume Next

  InGroup = False
  'Wyszukiwanie grupy strGroup w zmiennej strUserGroups
  If Instr( 1, LCase( strUserGroups ), LCase( strGroup ), 1) Then InGroup = True

End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:      GetSystemInfo
'
' Dziaanie:      Pobranie podstawowych informacji o systemie
'
' Parametry wejciowe:
'
' Wynik:          strDomain, strOSProdType, strWorkstation, strLogonPath
'
' Zastosowanie:   Call GetSystemInfo
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub GetSystemInfo

  On Error Resume Next

  'Pobranie nazwy domeny
  If objWshShell.ExpandEnvironmentStrings( "%OS%" ) = "Windows_NT" Then
    strDomain = objWshNetwork.UserDomain
  Else
    strDomain = objWshShell.RegRead( "HKLM\System\CurrentControlSet\" & _
                "Services\MSNP32\NetWorkProvider\AuthenticatingAgent" )
  End If

  'Pobranie typu produktu z rejestru (WinNT, LanmanNT, ServerNT)
  strOSProdType = objWshShell.RegRead( _
    "HKLM\System\CurrentControlSet\Control\ProductOptions\ProductType")

  'Pobranie nazwy komputera
  If IsTerminalServerSession = True Then
    'Ustawienie zmiennej strWorkstation na jej rzeczywist nazw, a nie nazw serwera
    strWorkstation = objWshShell.ExpandEnvironmentStrings( "%CLIENTNAME%" )
  Else
    strWorkstation = objWshNetwork.ComputerName
  End If

  'Pobranie cieki do katalogu, w ktrym dziaa skrypt
  strLogonPath = Left( Wscript.ScriptFullName, _
    ( InstrRev( Wscript.ScriptFullName, "\") -1))

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Funkcja :   IsTerminalServer
'
' Dziaanie:  Sprawdzenie, czy uytkownik dziaa w sesji terminala
'
' Parametry wejciowe:
'
' Wynik:
'           True, w przypadku dziaania w sesji serwera terminala 
'           False w przeciwnym przypadku
' Zastosowanie:
'           If IsTerminalServerSession = True Then <dziaania>
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function IsTerminalServerSession

  On Error Resume Next

  Dim strName

  'Sprawdzenie, czy to jest sesja serwera terminala
  'Jeli tak, ustawienie nazwy klienta
  strName = objWshShell.ExpandEnvironmentStrings( "%CLIENTNAME%" )
  If strName <> "%CLIENTNAME%" AND strName <> "" Then _
    IsTerminalServerSession = True

End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura: SetupIE
'
' Dziaanie: Konfiguracja przegldarki Internet Explorer do dziaania jako okno komunikatw
'
' Parametry wejciowe:
'
' Wynik:
'
' Zastosowanie:    Call SetupIE
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub SetupIE

  On Error Resume Next

  Dim strTitle    'Tytu okna przegldarki IE
  Dim intCount    'Licznik wykorzystywany podczas dziaania procedury AppActivate

  strTitle = "Stan skryptu logowania"

  'Utworzenie odwoania do obiektu objIntExplorer
  'Obiekt ten bdzie wykorzystany do wywietlania komunikatw. Ustawienie atrybutw wywietlania
  ' przegldarki IE    Set objIntExplorer = Wscript.CreateObject("InternetExplorer.Application")
  With objIntExplorer
    .Navigate "about:blank"
    .ToolBar   = 0
    .Menubar   = 0
    .StatusBar = 0
    .Width     = 600
    .Height    = 350
    .Left      = 100
    .Top       = 100
  End With

  'Ustawienie formatowania
  With objIntExplorer.Document
    .WriteLn ("<!doctype html public>")
    .WriteLn   ("<head>")
    .WriteLn     ("<title>" & strTitle & "</title>")
    .WriteLn     ("<style type=""text/css"">")
    .WriteLn       ("body {text-align: left; font-family: arial; font-size: 10pt}")
    .WriteLn     ("</style>")
    .WriteLn   ("</head>")
  End With

  'Oczekiwanie na zakoczenie dziaania przegldarki IE
  Do While (objIntExplorer.Busy)
    Wscript.Sleep 200
  Loop

  'Wywietlenie przegldarki IE
  objIntExplorer.Visible = 1

  'Uaktywnienie okna przegldarki IE
  For intCount = 1 To 100
    If objWshShell.AppActivate(strTitle) Then Exit For
    WScript.Sleep 50
  Next

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:      UserPrompt
'
' Dziaanie:      Wykorzystanie przegldarki Internet Explorer jako okna komunikatw o stanie
'
' Parametry wejciowe:    strPrompt
'
' Wynik:   Wynik dziaania procedury jest przesyany do okna przegldarki Internet Explorer
'
' Zastosowanie:
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub UserPrompt( strPrompt )

  On Error Resume Next

  objIntExplorer.Document.WriteLn (strPrompt & "<br />")

End Sub

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:      Cleanup
'
' Dziaanie:      Odtworzenie globalnych obiektw i zakoczenie dziaania skryptu
'
' Parametry wejciowe:
'
' Wynik:
'
' Zastosowanie:    Call Cleanup
'
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Sub Cleanup

  On Error Resume Next

  Set objFileSys     = Nothing
  Set objWshNetwork  = Nothing
  Set objWshShell    = Nothing
  Set objIntExplorer = Nothing

  'Zakoczenie dziaania skryptu
  Wscript.Quit()

End Sub
