' Wywietlenie drzewa katalogw

Option Explicit
Dim sArg, oFSO
Set oFSO = CreateObject("Scripting.FileSystemObject")

' Pobranie informacji o folderze (domylnym folderem jest katalog biecy)
If Wscript.Arguments.Count > 0 Then
sArg = Wscript.Arguments(0)
Else
sArg = "."
End If
sArg = oFSO.GetAbsolutePathName(sArg)

' Przetwarzanie caego drzewa (jeli folder jest prawidowy)
If oFSO.FolderExists(sArg) Then
Wscript.Echo "Folder tree for:", sArg
ShowTree "", oFSO.GetFolder(sArg)
End If

Set oFSO = Nothing
Wscript.Quit(0)


Sub ShowTree(sIndent, oFolder)
Dim oSubFolder, ix
ix = 1
For Each oSubFolder In oFolder.SubFolders
Wscript.Echo sIndent & "+--" & oSubFolder.Name
If ix <> oFolder.SubFolders.Count Then
ShowTree sIndent & "| ", oSubFolder
Else
ShowTree sIndent & " ", oSubFolder
End If
ix = ix + 1
Next
End Sub
