'Nazwa skryptu: ExecuteAll.vbs

Option Explicit

Dim oDomain, oService, oItem, oShell
Dim strDomain, strSpec, strCommand, intButton
Dim oArgs, strFinalCommand, oRegEx, boolConfirm

' Przygotowanie do wykonania polece i wywietlenie komunikatw
Set oShell = CreateObject("WScript.Shell")

GetArguments

' Dostp do domeny
WScript.Echo "Dostp do domeny NT " & strDomain
Set oDomain = GetObject("WinNT://" & strDomain)

' Zainicjowanie obsugi wyrae regularnych
Set oRegEx = New RegExp
oRegEx.Pattern = strSpec
oRegEx.IgnoreCase = True

' Przetwarzanie wszystkich komputerw w domenie (obiektw WinNT)
WScript.Echo "Wyszukiwanie " & strSpec
oDomain.Filter = Array("Computer") ' wyszukiwanie tylko komputerw
For Each oItem In oDomain
If oRegEx.Test(oItem.Name) Then
WScript.Echo " Nazwa speaniajca kryteria " & oItem.Name
strFinalCommand = Replace(strCommand, "$n", oItem.Name)

intButton = vbNo
If boolConfirm Then
intButton = oShell.Popup("Wykonywanie polecenia " & strFinalCommand & "?",,_
"System " & oItem.Name, vbYesno + vbQuestion)
End If
If (boolConfirm = False) Or (intButton = vbYes) Then
WScript.Echo " Wykonywanie polecenia: " & strFinalCommand
execute strFinalCommand
End If
End If
Next

' Dziaania wykonano - porzdkowanie
Set oItem = Nothing
Set oRegEx = Nothing
Set oDomain = Nothing
Set oShell = Nothing
Set oArgs = Nothing

'
' Pobranie argumentw wykonania z wiersza polecenia.
' W przypadku braku argumentw, pytanie o ich wprowadzenie. Wprowadzenie pustego cigu
' oznacza wyjcie z procedury
'
' /Y jest opcjonalnym ostatnim argumentem
Sub GetArguments
Dim i, strConfirm, intButton
Set oArgs = WScript.Arguments

boolConfirm = True ' zaoenie cigego potwierdzania
strDomain = "" ' domena fo przegldania
strSpec = "" ' specyfikacja nazwy
strCommand = "" ' polecenie do wykonania
strConfirm = "" ' ustawienie pytania o potwierdzenie

' Wyszukiwanie opcjonalnego 4-go argumentu
If oArgs.Length = 4 Then
If UCase(oArgs.Item(3)) = "/Y" Then
boolConfirm = False
strConfirm = "/Y" ' pytanie o potwierdznei nie zostanie wywietlone
End If
End If

' Wyszukiwanie wprowadzonych argumentw
If oArgs.Length >= 1 Then strDomain = oArgs(0)
If oArgs.Length >= 2 Then strSpec = oArgs(1)
If oArgs.Length >= 3 Then strCommand = oArgs(2)

' Pytanie o argumenty, ktrych nie wprowadzono w wierszu polecenia
If strDomain = "" Then
strDomain = InputBox _
("Wprowad nazw domeny NT", _
"Domena NT")
End If
If strDomain = "" Then WScript.Quit
strDomain = UCase(strDomain)

If strSpec = "" Then
strSpec = InputBox _
("Wprowad specyfikacj nazwy komputerw, " & _
"dla ktrych ma by wykonane polecenie w domenie " & strDomain & "." & _
vbCrlf & "Mona stosowa wyraenia regularne.", _
"Specyfikacja nazwy")
End If
If strSpec = "" Then WScript.Quit

If strCommand = "" Then
strCommand = InputBox _
("Wprowad nazw polecenia, ktre ma by wykonane w kadym komputerze speniajcym warunki " & _
strSpec & " w domenie " & strDomain & "." & _
vbCrlf & "$n zostanie zastpione nazw komputera.", _
"Polecenie do wykonania")
End If
If strCommand = "" Then WScript.Quit

If strConfirm = "" Then
intButton = oShell.Popup("Potwierdza polecenia przed wykonaniem?",,_
"Potwierdza?", vbYesNo + vbQuestion)
If intButton = vbNo Then
boolConfirm = False
End If
End If
End Sub

' Wykonanie polecenia. Kade jest uruchamiane za pomoc nowego egzemplarza' procesora polece. Dziki temu mona wykorzysta wbudowane polecenia oraz przekierowanie We-Wy.
'
' Bez oczekiwania na zakoczenie polecenia.
Sub Execute(strCommand)
Dim RetVal

strCommand = "%COMSPEC% /c " & strCommand

RetVal = oShell.Run(strCommand, 1, False)
End Sub
