Option Explicit
'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Plik:          vbsWaitForProcess.vbs
' Aktualizacja:  Listopad 2002
' Wersja:        1.0
' Autor:         Dan Thomson, felietonista myITforum.com
'                Jestem dostpny pod adresem dethomson@hotmail.com
'
' Zastosowanie:  Naley uruchomi procesor polece za pomoc cscript
'                cscript vbsWaitForProcess.vbs notepad.exe 60 S
'                lub
'                Wersje IE i Popup mona uruchomi za pomoc cscript lub wscript
'                wscript vbsWaitForProcess.vbs notepad.exe -1
'
' Parematry we:  Nazwa programu  (np.: notepad.exe)
'                Czas oczekiwania w sekundach przed zakoczeniem programu
'                -1 oczekiwanie na zakoczenie procesu w nieskoczono
'                0 natychmiast koczy proces
'                Dowolna warto > 0 spowoduje, e skrypt bdzie oczekiwa
'                okrelon liczb sekund przed zakoczeniem procesu
'           Tryb bez komunikatw  (S)
'
' Uwagi:
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

On Error Resume Next

'Zdefiniowanie zmiennych
Dim strProcess
Dim intWaitTime
Dim strSilent

'Pobranie argumentw wiersza polecenia
strProcess = Wscript.Arguments.Item(0)
intWaitTime = CInt(Wscript.Arguments.Item(1))
strSilent = Wscript.Arguments.Item(2)

Call WaitForProcess (strProcess, intWaitTime, strSilent)

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Funkcja:        ProcessIsRunning
'
' Przeznaczenie:  Sprawdza, czy proces dziaa
'
' Parametr we:    Nazwa procesu
'
' Wynik:          True lub False w zalenoci od tego, czy proces dziaa
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function ProcessIsRunning( strProcess )
    Dim colProcessList

    Set colProcessList = Getobject("Winmgmts:").Execquery _
        ("Select * from Win32_Process Where Name ='" & strProcess & "'")
    If colProcessList.Count > 0 Then
        ProcessIsRunning = True
    Else
        ProcessIsRunning = False
    End If

    Set colProcessList = Nothing
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Funkcja:          TerminateProcess
'
' Przeznaczenie:    Koczy proces
'
' Parametr we:      Nazwa procesu
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Function ProcessTerminate( strProcess )
    Dim colProcessList, objProcess

    Set colProcessList = GetObject("Winmgmts:").ExecQuery _
        ("Select * from Win32_Process Where Name ='" & strProcess & "'")
    For Each objProcess in colProcessList
        objProcess.Terminate( )
    Next

    Set colProcessList = Nothing
End Function

'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Procedura:      WaitForProcess
'
' Przeznaczenie:  Oczekiwanie na proces
'
' Parametry we:   Nazwa procesu
'                 Czas oczekiwania w sekundach przed zakoczeniem procesu.
'                 -1 spowoduje oczekiwanie w nieskoczono
'                 0 spowoduje natychmiastowe zakoczenie procesu
'                 Kada warto > 0 spowoduje, e skrypt bdzie czeka
'                 okrelon liczb sekund przed zakoczeniem procesu
'             Tryb wywietlania.
'                 Parametr S spowoduje dziaanie w trybie bez wywietlania komunikatw
'
' Wynik:      Status wywietlany na ekranie
'
' Uwagi:      Niniejsza wersja wywietla komunikaty w oknie za pomoc StdOut
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Private Sub WaitForProcess( strProcess, intWaitTime, strMode )

  If ProcessIsRunning(strProcess) Then
    Dim StdOut
    Dim w : w = 0
    Dim strPrompt
    Dim intPause : intPause = 1

    If UCase(strMode) <> "S" Then
      strPrompt = "Oczekiwanie na zakoczenie " & strProcess & "."
      Set StdOut = WScript.StdOut
      StdOut.WriteLine ""
      StdOut.Write strPrompt
    End If
    'Ptla podczas dziaania procesu
    Do While ProcessIsRunning(strProcess)
      'Sprawdzenie, czy upyna okrelona liczba sekund przed zakoczeniem
      'procesu. Jeli tak - zakoczenie procesu
      If w >= intWaitTime AND intWaitTime >= 0 Then
        Call ProcessTerminate(strProcess)
        Exit Do
      End If
      'Jeli procedura nie dziaa w trybie bez komunikatw - wywietlenie informacji
      If UCase(strMode) <> "S" Then _
        StdOut.Write "."
      'Inkrementacja licznika sekund
      w = w + intPause
      'Pause
      Wscript.Sleep(intPause * 1000)
    Loop
    If UCase(strMode) <> "S" Then
      StdOut.WriteLine ""
      Set StdOut = Nothing
    End If
  End If
End Sub
