Option Explicit

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
' Plik:          ExportADUsers.vbs
' Aktualizacja:  Grudzie 2003
' Wersja:        1.0
' Autor:         Dan Thomson - felietonista myITforum.com
'                kontakt dethomson@hotmail.com
'
' Uycie:        Niniejszy skrypt uruchamia si za pomoc mechanizmu cscript.
'                cscript ExportADUsers.vbs
'
' Parametry We:  Brak
'
' Uwagi:         Ten skrypt eksportuje dane wszystkich uytkownikw, ktrych konta 
'                nie zostay zablokowane i nie utraciy wanoci oraz nie maj 
'                klauzuli NoExport w sekcji Uwagi.
'                W skrypcie zdefiniowano sta "Users2Skip", gdzie mona dodawa 
'                nazwy uytkownikw, ktre nie maj by eksportowane.
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

On Error Resume Next

' Nazwa bazy danych Accessa do wykorzystania
Const AccessDatabase = "EmployeeInfo.mdb"
' Nazwa tabeli bazy danych Accessa do wykorzystania
Const AccessTable    = "tblEmployeeInfo"

' Lista uytkownikw, ktrych dane nie maj by eksportowane
' Na licie powinny znale si nazwy logowania uytkownikw
' rozdzielone przecinkami
Const Users2Skip     = "Go"

' Staa dla kont zablokowanych
Const ADS_UF_ACCOUNTDISABLE = 2
' Staa wyszukiwania do przeszukiwania poddrzew
Const ADS_SCOPE_SUBTREE     = 2

Const adOpenStatic     = 3
Const adLockOptimistic = 3

' Deklaracje zmiennych oglnych
Dim objConnectionDB, objRecordsetDB
Dim objConnectionAD, objCommandAD, objRecordsetAD
Dim dtStart
Dim strSQL
Dim objRootDSE, strDNSDomain
Dim strDN, intUAC, strSam, strDisplayName, strManagerDN, dtExpireDate
Dim blnProcessUser
Dim objUser, objManager

' Pobranie czasu rozpoczcia skryptu
dtStart = TimeValue(Now( ))

'Utworzenie i otwarcie poczenia ADO z baz danych Accessa
Set objConnectionDB = CreateObject("ADODB.Connection")
Set objRecordsetDB  = CreateObject("ADODB.Recordset")

' Otwarcie bazy danych
objConnectionDB.Open "Provider=Microsoft.Jet.OLEDB.4.0;" & _
                     "Data Source=" & AccessDatabase & ";"

' Otwarcie rda rekordw
objRecordsetDB.Open AccessTable, objConnectionDB, adOpenStatic, adLockOptimistic

' Zdefiniowanie instrukcji SQL wykorzystywanej do wyzerowania
' informacji poprzednio wyeksportowanych z AD
strSQL = "DELETE FROM " & AccessTable & " WHERE ImportedFromAD = 'True'"

Wscript.Echo "Usunicie poprzednio wyeksportowanych rekordw z bazy danych " & _
    AccessDatabase & "."
objConnectionDB.Execute strSQL, , 129

' Domena DNS z obiektu RootDSE.
Set objRootDSE = GetObject("LDAP://RootDSE")
strDNSDomain   = objRootDSE.Get("defaultNamingContext")

' Utworzenie i otwarcie poczenia ADO z AD
Set objConnectionAD = CreateObject("ADODB.Connection")
Set objCommandAD    = CreateObject("ADODB.Command")

objConnectionAD.Provider = "ADsDSOObject"
objConnectionAD.Open "Active Directory Provider"

' Ustawienie waciwoci poczenia
With objCommandAD
  .ActiveConnection = objConnectionAD

  ' Wykorzystanie skadni SQL dla zapytania
' Zapytanie pobiera wszystkie wartoci kont uytkownikw w sekcji SELECT
' dla ktrych sekcja Uwagi nie zawiera klauzuli NoExport.
' Zbir rekordw jest sortowany rosnco wedug wartoci displayName.
  .CommandText = _
             "Select userAccountControl, distinguishedName," & _
             " sAMAccountname, displayName" & _
             " FROM 'LDAP://" & strDNSDomain & "'" & _
             " WHERE objectCategory = 'person' AND" & _
             " objectClass = 'user' AND info <> 'NoExport'" & _
             " ORDER BY displayName"

  .Properties("Page Size")     = 1000
  .Properties("Timeout")       = 30
  .Properties("Searchscope")   = ADS_SCOPE_SUBTREE
  .Properties("Cache Results") = False
End With

Wscript.Echo "Uruchamianie zapytania w celu wyszukania uytkownikw."
Set objRecordSetAD = objCommandAD.Execute

' Przejcie do pierwszego rekordu w zbiorze rekordw
objRecordSetAD.MoveFirst

' Przetwarzanie w ptli a do koca zbioru rekordw
Do While NOT objRecordsetAD.EOF
  ' Wyzerowanie kilku zmiennych...na wszelki wypadek.
  strDN  = ""
  intUAC = ""
  strSam = ""
  strDisplayName = ""
  strManagerDN   = ""
  dtExpireDate   = ""
  blnProcessUser = True

  ' Pobranie wartoci userAccountControl. Dziki temu mona si dowiedzie, midzy innymi,
' czy konto zostao zablokowane.
  intUAC = objRecordsetAD.Fields("userAccountControl")

  ' Przetwarzanie informacji o uytkowniku, jeli konto nie zostao zablokowane.
  If (NOT intUAC AND ADS_UF_ACCOUNTDISABLE) Then

    ' Pobranie nazwy logowania uytkownika
    strSam         = objRecordsetAD.Fields("sAMAccountname")

    ' Sprawdzenie, czy nazwa uytkownika zmajduje si na licie kont do pominicia.
    If Instr(UCase(Users2Skip), UCase(strSam)) Then blnProcessUser = False

    ' Pobranie nazwy wywietlanej uytkownika
    strDisplayName = objRecordsetAD.Fields("displayName")

    ' Ustawienie zmiennej logicznej w celu pominicie uytkownika, jeli
    ' jego nazwa wywietlana jest pusta.
    If strDisplayName = "" Then blnProcessUser = False

    ' Jeli testy wypady pomylnie - moemy przetwarza dane uytkownika.
    If blnProcessUser = True Then

      ' Pobranie unikatowej nazwy uytkownika
      ' Skadnia jest nastpujca:
      '           CN=Jerzy E. Lew,OU=Sprzeda,OU=Polska,DC=mojadomena,DC=lokalna
      strDN = objRecordsetAD.Fields("distinguishedName")

      ' Powizanie z obiektem uytkownika
      Set objUser = GetObject("LDAP://" & strDN & "")

      ' Przetwarzanie informacji o uytkowniku
      With objUser
        Wscript.Echo "Przetwarzanie informacji o uytkowniku: " & strDisplayName

        ' Pobranie informacji o dacie wanoci konta uytkownika
        dtExpireDate = CDate(.AccountExpirationDate)

        ' Przetwarzanie informacji o uytkowniku, jeli nie upyna data wanoci jego konta
     If (dtExpireDate = "") OR _
          (dtExpireDate = CDate("01/01/1970")) OR _
          (dtExpireDate >= Date( )) Then

        'Dodanie nowego rekordu do bazy danych Accessa
        objRecordsetDB.AddNew
          ' Pobranie danych o uytkowniku z AD i wypenienie nowego rekordu
          ' w bazie danych Accessa

          ' W celu pobrania danych mona skorzysta z formatu .Get("xxx") lub .xxx
' Wszystkie pola wymienione po lewej musz wystpowa w bazie danych Accessa
          objRecordsetDB("FirstName")       = .Get("givenName")
          objRecordsetDB("MiddleName")      = .initials
          objRecordsetDB("LastName")        = .sn
          objRecordsetDB("DisplayName")     = .displayName
          objRecordsetDB("Description")     = .description
          objRecordsetDB("OfficeLocation")  = .physicalDeliveryOfficeName
          objRecordsetDB("WorkPhone")       = .telephoneNumber
          objRecordsetDB("Email")           = .mail
          objRecordsetDB("WebPage")         = .wwwHomePage
          objRecordsetDB("Street")          = .streetAddress
          objRecordsetDB("POBox")           = .postOfficeBox
          objRecordsetDB("City")            = .l
          objRecordsetDB("StateOrProvince") = .st
          objRecordsetDB("PostalCode")      = .postalCode
          objRecordsetDB("CountryOrRegion") = .co
          objRecordsetDB("HomePhone")       = .homePhone
          objRecordsetDB("Pager")           = .pager
          objRecordsetDB("MobilePhone")     = .mobile
          objRecordsetDB("FaxNumber")       = .facsimileTelephoneNumber
          objRecordsetDB("Notes")           = .info
          objRecordsetDB("Title")           = .title
          objRecordsetDB("Department")      = .department
          objRecordsetDB("CompanyName")     = .company

          ' Pobranie nazwy identyfikujcej menedera
          strManagerDN = .manager
          ' Przetwarzanie danych, jeli identyfikator menedera nie jest pusty
          If strManagerDN <> "" Then
            ' Powizanie z kontem menedera
            Set objManager = GetObject("LDAP://" & strManagerDN & "")
              ' Wypenienie bazy danych Accessa wywietlan nazw menedera
              objRecordsetDB("Manager")     = objManager.displayName
            ' Zwolnienie odwoania do obiektu
            Set objManager = Nothing
          End If

          ' Oznaczenie, e ten rekord wyeksportowano z AD
          objRecordsetDB("ImportedFromAD")  = "True"

        ' Zatwierdzenie rekordu
        objRecordsetDB.Update

        ' Zwolnienie odwoania do obiektu
        Set objUser = Nothing
        End If
      End With
    End If
  End If

 ' Przejcie do nastpnego rekordu w zbiorze rekordw AD
  objRecordsetAD.MoveNext
Loop

' Zamknicie zbioru danych bazy danych Accessa
objRecordsetDB.Close
' Zamknicie poczenia z baz danych Accessa
objConnectionDB.Close

' Zwolnienie odwoan do obiektw
Set objRecordsetDB = Nothing
Set objConnectionDB = Nothing

' Zamknicie zbioru danych AD
objRecordsetAD.Close
' Zamknicie poczenia AD
objConnectionAD.Close

' Zwolnienie odwoa do obiektu
Set objRecordsetAD = Nothing
Set objConnectionAD = Nothing

' Poinformowanie uytkownika o czasie wykonywania si skryptu
WScript.Echo "Skrypt wykona si w czasie okoo " & _
             Second(TimeValue(now( )) - dtStart) & _
             " sekund."

' To wszystko!
Wscript.Quit
