<?php
$books = array(
  array (
      id => 1,
      author => "Jack Herrington",
      name => "Generowanie kodu w praktyce"
    ),
  array (
      id => 2,
      author => "Jack Herrington",
      name => "100 sposobów na Podcasting"
    ),
  array (
      id => 3,
      author => "Jack Herrington",
      name => "100 sposobów na PHP"
    )
  );

$dom = new DomDocument();
$dom->formatOutput = true;

$root = $dom->createElement( "books" );
$dom->appendChild( $root );

foreach( $books as $book )
{
  $bn = $dom->createElement( "book" );
  $bn->setAttribute( 'id', $book['id'] );

  $author = $dom->createElement( "author" );
  $author->appendChild( $dom->createTextNode( $book['author'] ) );
  $bn->appendChild( $author );

  $name = $dom->createElement( "name" );
  $name->appendChild( $dom->createTextNode( $book['name'] ) );
  $bn->appendChild( $name );

  $root->appendChild( $bn );
}

header( "Content-type: text/xml" );
echo $dom->saveXML();
?>
