<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:d="http://simonstl.com/ns/dinosaurs/"
  xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
  xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 >

<xsl:output method="xml" omit-xml-declaration="no" indent="yes" encoding="US-ASCII"/>

<xsl:template match="/">
  <xsl:apply-templates select="d:dinozaury" />
</xsl:template>

<xsl:template match="d:dinozaury">

<xsl:processing-instruction name="mso-application">progid="Excel.Sheet"</xsl:processing-instruction>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:o="urn:schemas-microsoft-com:office:office"
 xmlns:x="urn:schemas-microsoft-com:office:excel"
 xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 xmlns:html="http://www.w3.org/TR/REC-html40">
 <DocumentProperties xmlns="urn:schemas-microsoft-com:office:office">
  <Author>Simon St.Laurent</Author>
  <LastAuthor>Simon St.Laurent</LastAuthor>
  <Created>2003-12-03T15:48:38Z</Created>
  <LastSaved>2003-12-03T15:57:46Z</LastSaved>
  <Company>O'Reilly &amp; Associates</Company>
  <Version>11.5606</Version>
 </DocumentProperties>
 <ExcelWorkbook xmlns="urn:schemas-microsoft-com:office:excel">
  <WindowHeight>6150</WindowHeight>
  <WindowWidth>8475</WindowWidth>
  <WindowTopX>120</WindowTopX>
  <WindowTopY>30</WindowTopY>
  <ProtectStructure>False</ProtectStructure>
  <ProtectWindows>False</ProtectWindows>
 </ExcelWorkbook>
 <Styles>
  <Style ss:ID="Default" ss:Name="Normal">
   <Alignment ss:Vertical="Bottom"/>
   <Borders/>
   <Font/>
   <Interior/>
   <NumberFormat/>
   <Protection/>
  </Style>
  <Style ss:ID="s21">
   <NumberFormat ss:Format="mmm\-yy"/>
  </Style>
  <Style ss:ID="s22">
   <NumberFormat ss:Format="&quot;$&quot;#,##0.00"/>
  </Style>
 </Styles>
 <Worksheet ss:Name="Arkusz1">
  <Table ss:ExpandedColumnCount="5" ss:ExpandedRowCount="{count(d:sprzedane)+4}" x:FullColumns="1"
   x:FullRows="1">
   <Column ss:AutoFitWidth="0" ss:Width="73.5"/>
   <Column ss:AutoFitWidth="0" ss:Width="96.75"/>
   <Column ss:Index="5" ss:AutoFitWidth="0" ss:Width="56.25"/>
   <Row>
    <Cell><Data ss:Type="String">Sprzeda za:</Data></Cell>
    <Cell ss:StyleID="s21"><Data ss:Type="DateTime"><xsl:value-of select="d:data"/></Data></Cell>
   </Row>
   <Row ss:Index="3">
    <Cell><Data ss:Type="String">Numer ID</Data></Cell>
    <Cell><Data ss:Type="String">Dinozaur</Data></Cell>
    <Cell><Data ss:Type="String">Cena</Data></Cell>
    <Cell><Data ss:Type="String">Liczba</Data></Cell>
    <Cell><Data ss:Type="String">Razem</Data></Cell>
   </Row>

<xsl:apply-templates select="d:sale" />

   <Row>
    <Cell ss:Index="4"><Data ss:Type="String">Razem:</Data></Cell>
    <Cell ss:StyleID="s22" ss:Formula="=SUM(R[-{count(d:sprzedane)}]C:R[-1]C)"><Data ss:Type="Number"></Data></Cell>
   </Row>
  </Table>
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <Print>
    <ValidPrinterInfo/>
    <HorizontalResolution>600</HorizontalResolution>
    <VerticalResolution>600</VerticalResolution>
   </Print>
   <Selected/>
   <Panes>
    <Pane>
     <Number>3</Number>
     <ActiveRow>12</ActiveRow>
     <ActiveCol>1</ActiveCol>
    </Pane>
   </Panes>
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
 <Worksheet ss:Name="Arkusz2">
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
 <Worksheet ss:Name="Arkusz3">
  <WorksheetOptions xmlns="urn:schemas-microsoft-com:office:excel">
   <ProtectObjects>False</ProtectObjects>
   <ProtectScenarios>False</ProtectScenarios>
  </WorksheetOptions>
 </Worksheet>
</Workbook>
</xsl:template>

<xsl:template match="d:sprzedane">
   <Row>
    <Cell><Data ss:Type="Number"><xsl:value-of select="d:ID" /></Data><NamedCell ss:Name="ID"/></Cell>
    <Cell><Data ss:Type="String"><xsl:value-of select="d:dinozaur" /></Data><NamedCell ss:Name="Dinozaury"/></Cell>
    <Cell ss:StyleID="s22"><Data ss:Type="Number"><xsl:value-of select="d:cena" /></Data><NamedCell
      ss:Name="Cena"/></Cell>
    <Cell><Data ss:Type="Number"><xsl:value-of select="d:liczba" /></Data><NamedCell ss:Name="Liczba"/></Cell>
    <Cell ss:StyleID="s22" ss:Formula="=RC[-2]*RC[-1]"><Data ss:Type="Number"><xsl:value-of select="d:razem" /></Data></Cell>
   </Row>
</xsl:template>

<xsl:template match="d:data" />
<xsl:template match="d:razem" />

</xsl:stylesheet>
