<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://simonstl.com/ns/dinosaurs/"
  xmlns:ss="urn:schemas-microsoft-com:office:spreadsheet"
 >

<xsl:output method="xml" omit-xml-declaration="yes" indent="yes" encoding="US-ASCII"/>

<xsl:template match="/">
  <xsl:apply-templates select="ss:Workbook"/> 
</xsl:template>

<xsl:template match="ss:Workbook">
  <dinozaury>
       <xsl:apply-templates select="ss:Worksheet[@ss:Name = 'Arkusz1']"/> 
  </dinozaury>
</xsl:template>

<xsl:template match="ss:Worksheet">
   <data><xsl:value-of select="ss:Table/ss:Row/ss:Cell[@ss:StyleID = 's21']" /></data>
   <xsl:apply-templates select="ss:Table" />
</xsl:template>

<xsl:template match="ss:Table">
   <xsl:apply-templates select="ss:Row[position() &gt; 2]" />
<!--Excel ignoruje pusty wiersz, wic trzeci wiersz jest na pozycji 2-->
</xsl:template>

<xsl:template match="ss:Row[ss:Cell[4]]">
<sprzedane>
   <ID><xsl:apply-templates select="ss:Cell[1]" /></ID>
   <dinozaur><xsl:apply-templates select="ss:Cell[2]" /></dinozaur>
   <cena><xsl:apply-templates select="ss:Cell[3]" /></cena>
   <liczba><xsl:apply-templates select="ss:Cell[4]" /></liczba>
   <razem><xsl:apply-templates select="ss:Cell[5]" /></razem>
</sprzedane>
</xsl:template>

<xsl:template match="ss:Row">
<razem><xsl:apply-templates select="ss:Cell[2]" /></razem>
</xsl:template>

</xsl:stylesheet>
