// Kod ten dziedziczy z klasy org.apache.poi.hssf.dev.HSSF,
// dlatego naley umieci w nim informacje o licencji.
/* ====================================================================
* The Apache Software License, Version 1.1
*
* Copyright (c) 2003 The Apache Software Foundation.  All rights
* reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
*
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
*
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in
*    the documentation and/or other materials provided with the
*    distribution.
*
* 3. The end-user documentation included with the redistribution,
*    if any, must include the following acknowledgment:
*       "This product includes software developed by the
*        Apache Software Foundation (http://www.apache.org/)."
*    Alternately, this acknowledgment may appear in the software itself,
*    if and wherever such third-party acknowledgments normally appear.
*
* 4. The names "Apache" and "Apache Software Foundation" and
*    "Apache POI" must not be used to endorse or promote products
*    derived from this software without prior written permission. For
*    written permission, please contact apache@apache.org.
*
* 5. Products derived from this software may not be called "Apache",
*    "Apache POI", nor may "Apache" appear in their name, without
*    prior written permission of the Apache Software Foundation.
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
* DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
* ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
* USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
* ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
* OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
* ====================================================================
*
* This software consists of voluntary contributions made by many
* individuals on behalf of the Apache Software Foundation.  For more
* information on the Apache Software Foundation, please see
* <http://www.apache.org/>.
*/

import java.io.*;

import java.util.Random;

import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.hssf.record.*;
import org.apache.poi.hssf.model.*;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.hssf.util.*;



public class PoiDemo {

    public static void main (String[] args) throws Exception {
        short rownum;

// utworzenie pliku docelowego
        FileOutputStream out = new FileOutputStream("arkusz_poi.xls");

// utworzenie obiektu nowego skoroszytu;
// skoroszyt i plik bd dwoma oddzielnymi obiektami a do momentu
// zapisania skoroszytu w pliku.
        HSSFWorkbook wb = new HSSFWorkbook();

// utworzenie nowego arkusza
        HSSFSheet ws = wb.createSheet();

// utworzenie obiektu wiersza, wykorzystywanego pniej
        HSSFRow r = null;

// utworzenie obiektu odwoania do komrki
        HSSFCell c = null;
// utworzenie dwch styli komrek - formatw
// naley je utworzy przed ich uyciem
        HSSFCellStyle cs1 = wb.createCellStyle();
        HSSFCellStyle cs2 = wb.createCellStyle();
        HSSFDataFormat df = wb.createDataFormat();
// utworzenie dwch obiektw czcionek dla celw formatowania
        HSSFFont f1 = wb.createFont();
        HSSFFont f2 = wb.createFont();

// czcionka 1: 12 punktw, pogrubiona
        f1.setFontHeightInPoints((short) 10);
        f1.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

// czcionka 2: 10 punktw, w kolorze czerwonym
        f2.setFontHeightInPoints((short) 10);
        f2.setColor( (short)HSSFFont.COLOR_RED );

// w komrce o stylu 1 wstawienie czcionki 1 i ustawienie formatu danych
        cs1.setFont(f1);
        cs1.setDataFormat(df.getFormat("#,##0.0"));

// w komrce o stylu 2 wstawienie czcionki 2, ustawienie wskiego obramowania i formatu tekstowego
        cs2.setBorderBottom(cs2.BORDER_THIN);
        cs2.setDataFormat(HSSFDataFormat.getBuiltinFormat("text"));
        cs2.setFont(f2);

// zdefiniowanie nazwy arkusza w Unicode
        wb.setSheetName(0, "Arkusz testowy",
                HSSFWorkbook.ENCODING_UTF_16 );

// utworzenie arkusza z 10 wierszami
        for (rownum = (short) 0; rownum < 10; rownum++)
        {
            // utworzenie wiersza
            r = ws.createRow(rownum);

            // utworzenie 6 komrek (0-5); += 2 ujawni si pniej
            for (short cellnum = (short) 0; cellnum < 6; cellnum += 2)
            {
                // utworzenie komrki liczbowej
                c = r.createCell(cellnum);
                // wypenienie liczbami zalenymi od aktualnej pozycji
                c.setCellValue(rownum * 10 + cellnum
                        + (((double) rownum / 10)
                        + ((double) cellnum / 100)));



                // utworzenie komrki dla acucha znakw (std += 2 wczeniej)
                c = r.createCell((short) (cellnum + 1));

                // w co drugim wierszu
                if ((rownum % 2) == 0)
                {
                    // zdefiniowanie w komrce pierwszego zdefiniowanego stylu
                    c.setCellStyle(cs1);
                    // wpisanie w komrce acuchowej wartoci "Test"
                    c.setEncoding( HSSFCell.ENCODING_UTF_16 );
                    c.setCellValue( "Test" );
                }
                else
                {
                    c.setCellStyle(cs2);
                    // wpisanie w komrce acuchowej wartoci "1... 2... 3..."
                    c.setEncoding( HSSFCell.ENCODING_UTF_16 );
                    c.setCellValue( "1... 2... 3..." );
                }
            }
        }

// uycie paru formu
// zwikszenie numeru wiersza
        rownum++;
        r = ws.createRow(rownum);

// utworzenie formu
        for (short cellnum = (short) 0; cellnum < 6; cellnum += 2)
        {
            // utworzenie SUMY odpowiednich kolumn
            int column= 65+cellnum;
            char columnLabel=(char)column;
            String formula="SUM("+columnLabel+"1:"+columnLabel+"10)";
            c = r.createCell(cellnum);
            c.setCellStyle(cs1);
            c.setCellFormula(formula);
        }

// zapisanie skoroszytu w strumieniu wyjciowym,
// pamitamy o zamkniciu pliku
        wb.write(out);
        out.close();
     }
}
